/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.ClassScanner;
import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.code.client.ClassClient;
import com.gitee.fastmybatis.core.ext.exception.GenCodeException;
import com.gitee.fastmybatis.core.ext.exception.MapperFileException;
import com.gitee.fastmybatis.core.mapper.Mapper;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.io.SAXReader;
import org.springframework.core.io.ByteArrayResource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.xml.sax.SAXException;

public class MapperLocationsBuilder {
    private static final Log LOG = LogFactory.getLog(MapperLocationsBuilder.class);
    private static final String ENCODE = "UTF-8";
    private static final String EMPTY = "";
    private static final String XML_SUFFIX = ".xml";
    private static final String NODE_MAPPER = "mapper";
    private static final String MAPPER_START = "<mapper>";
    private static final String MAPPER_END = "</mapper>";
    private static final String MAPPER_EMPTY = "<mapper/>";
    private static final String ATTR_NAMESPACE = "namespace";
    private static final String SAXREADER_FEATURE = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    private static final String EXT_MAPPER_PLACEHOLDER = "<!--_ext_mapper_-->";
    private static final String TEMPLATE_SUFFIX = ".vm";
    private static final String DEFAULT_CLASS_PATH = "/fastmybatis/tpl/";
    private Map<String, MapperResourceDefinition> mapperResourceStore = new HashMap<String, MapperResourceDefinition>();
    private FastmybatisConfig config = new FastmybatisConfig();
    private Attribute namespace = new DOMAttribute(new QName("namespace"));
    private List<String> mapperNames = Collections.emptyList();
    private String dbName;

    public Resource[] build(String basePackage) {
        try {
            String[] basePackages = StringUtils.tokenizeToStringArray((String)basePackage, (String)",; \t\n");
            ClassScanner classScanner = new ClassScanner(basePackages, Mapper.class);
            Set<Class<?>> clazzsSet = classScanner.getClassSet();
            this.initContext(clazzsSet);
            this.mapperNames = this.buildMapperNames(clazzsSet);
            Resource[] resourceArray = this.buildMapperLocations(clazzsSet);
            return resourceArray;
        }
        catch (Exception e) {
            LOG.error((Object)"\u6784\u5efamapper\u5931\u8d25", (Throwable)e);
            throw new MapperFileException(e);
        }
        finally {
            this.distroy();
        }
    }

    private void distroy() {
        this.mapperResourceStore.clear();
    }

    public void storeMapperFile(Resource[] mapperLocations) {
        for (Resource mapperLocation : mapperLocations) {
            String filename = mapperLocation.getFilename();
            this.mapperResourceStore.put(filename, new MapperResourceDefinition(mapperLocation));
        }
    }

    private MapperResourceDefinition getMapperFile(String mapperFileName) {
        return this.mapperResourceStore.get(mapperFileName);
    }

    private Resource[] buildMapperLocations(Set<Class<?>> clazzsSet) {
        List<Resource> mapperLocations = this.buildMapperResource(clazzsSet);
        this.addUnmergedResource(mapperLocations);
        this.addCommonSqlClasspathMapper(mapperLocations);
        return mapperLocations.toArray(new Resource[mapperLocations.size()]);
    }

    private List<Resource> buildMapperResource(Set<Class<?>> clazzsSet) {
        int classCount = clazzsSet.size();
        if (classCount == 0) {
            return new ArrayList<Resource>();
        }
        String templateLocation = this.buildTemplateLocation(this.getDbName());
        String globalVmLocation = this.config.getGlobalVmLocation();
        LOG.info((Object)("\u4f7f\u7528\u6a21\u677f:" + templateLocation));
        ClassClient codeClient = new ClassClient(this.config);
        ArrayList<Resource> mapperLocations = new ArrayList<Resource>(classCount);
        long startTime = System.currentTimeMillis();
        try {
            for (Class<?> daoClass : clazzsSet) {
                String xml = codeClient.genMybatisXml(daoClass, templateLocation, globalVmLocation);
                xml = this.mergeExtMapperFile(daoClass, xml);
                mapperLocations.add((Resource)new MapperResource(xml, daoClass));
            }
            long endTime = System.currentTimeMillis();
            LOG.info((Object)("\u751f\u6210Mapper\u5185\u5bb9\u603b\u8017\u65f6\uff1a" + (double)(endTime - startTime) / 1000.0 + "\u79d2"));
            this.saveMapper(this.config.getMapperSaveDir(), mapperLocations);
            return mapperLocations;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new GenCodeException(e);
        }
    }

    private List<String> buildMapperNames(Set<Class<?>> clazzsSet) {
        ArrayList<String> list = new ArrayList<String>(clazzsSet.size());
        for (Class<?> mapperClass : clazzsSet) {
            list.add(mapperClass.getSimpleName());
        }
        return list;
    }

    private void initContext(Set<Class<?>> clazzsSet) {
        for (Class<?> mapperClass : clazzsSet) {
            ExtContext.addMapperClass(mapperClass);
        }
    }

    private void saveMapper(String saveDir, List<Resource> mapperLocations) throws IOException {
        if (StringUtils.hasText((String)saveDir)) {
            LOG.info((Object)("\u4fdd\u5b58mapper\u6587\u4ef6\u5230" + saveDir));
            for (Resource resource : mapperLocations) {
                FileOutputStream out = new FileOutputStream(saveDir + "/" + resource.getFilename());
                Throwable throwable = null;
                try {
                    IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)out);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out == null) continue;
                    if (throwable != null) {
                        try {
                            ((OutputStream)out).close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ((OutputStream)out).close();
                }
            }
        }
    }

    private String buildTemplateLocation(String dbName) {
        String templateClasspath = this.config.getTemplateClasspath();
        if (StringUtils.isEmpty((Object)templateClasspath)) {
            templateClasspath = DEFAULT_CLASS_PATH;
        }
        return templateClasspath + this.buildTemplateFileName(dbName);
    }

    private String buildTemplateFileName(String dbName) {
        dbName = dbName.replaceAll("\\s", EMPTY).toLowerCase();
        return dbName + TEMPLATE_SUFFIX;
    }

    private void addCommonSqlClasspathMapper(List<Resource> mapperLocations) {
        String commonSqlClasspath = this.config.getCommonSqlClasspath();
        ClassPathResource res = new ClassPathResource(commonSqlClasspath);
        mapperLocations.add((Resource)res);
    }

    private void addUnmergedResource(List<Resource> mapperLocations) {
        Collection<MapperResourceDefinition> mapperResourceDefinitions = this.mapperResourceStore.values();
        for (MapperResourceDefinition mapperResourceDefinition : mapperResourceDefinitions) {
            if (mapperResourceDefinition.isMerged()) continue;
            LOG.info((Object)("\u52a0\u8f7d\u672a\u5408\u5e76Mapper\uff1a" + mapperResourceDefinition.getFilename()));
            mapperLocations.add(mapperResourceDefinition.getResource());
        }
    }

    private String mergeExtMapperFile(Class<?> mapperClass, String xml) throws IOException, DocumentException {
        String mapperFileName = mapperClass.getSimpleName() + XML_SUFFIX;
        MapperResourceDefinition mapperResourceDefinition = this.getMapperFile(mapperFileName);
        StringBuilder extXml = new StringBuilder();
        if (mapperResourceDefinition != null) {
            String extFileContent = this.getExtFileContent(mapperResourceDefinition.getResource());
            extXml.append(extFileContent);
            mapperResourceDefinition.setMerged(true);
        }
        String otherMapperXml = this.buildOtherMapperContent(mapperClass, this.mapperResourceStore.values());
        extXml.append(otherMapperXml);
        xml = xml.replace(EXT_MAPPER_PLACEHOLDER, extXml.toString());
        return xml;
    }

    private String buildOtherMapperContent(Class<?> mapperClass, Collection<MapperResourceDefinition> mapperResourceDefinitions) throws IOException, DocumentException {
        StringBuilder xml = new StringBuilder();
        String trueNamespace = mapperClass.getName();
        for (MapperResourceDefinition mapperResourceDefinition : mapperResourceDefinitions) {
            String namespaceValue;
            String filename = mapperResourceDefinition.getFilename();
            filename = filename.substring(0, filename.length() - 4);
            if (mapperResourceDefinition.isMerged() || this.mapperNames.contains(filename)) continue;
            Resource resource = mapperResourceDefinition.getResource();
            InputStream in = resource.getInputStream();
            Document document = this.buildSAXReader().read(in);
            Element mapperNode = document.getRootElement();
            Attribute attrNamespance = mapperNode.attribute(ATTR_NAMESPACE);
            String string = namespaceValue = attrNamespance == null ? null : attrNamespance.getValue();
            if (StringUtils.isEmpty((Object)namespaceValue)) {
                throw new MapperFileException("Mapper\u6587\u4ef6[" + mapperResourceDefinition.getFilename() + "]\u7684namespace\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            }
            if (!trueNamespace.equals(namespaceValue)) continue;
            String rootNodeName = mapperNode.getName();
            if (!NODE_MAPPER.equals(rootNodeName)) {
                throw new MapperFileException("mapper\u6587\u4ef6\u5fc5\u987b\u542b\u6709<mapper>\u8282\u70b9,\u662f\u5426\u7f3a\u5c11<mapper></mapper>?");
            }
            mapperNode.remove(this.namespace);
            String contentXml = mapperNode.asXML();
            contentXml = contentXml.replace(MAPPER_START, EMPTY).replace(MAPPER_END, EMPTY).replace(MAPPER_EMPTY, EMPTY);
            xml.append(contentXml);
            mapperResourceDefinition.setMerged(true);
        }
        return xml.toString();
    }

    private String getExtFileContent(Resource resource) throws IOException, DocumentException {
        InputStream in = resource.getInputStream();
        Document document = this.buildSAXReader().read(in);
        Element mapperNode = document.getRootElement();
        String rootNodeName = mapperNode.getName();
        if (!NODE_MAPPER.equals(rootNodeName)) {
            throw new MapperFileException("mapper\u6587\u4ef6\u5fc5\u987b\u542b\u6709<mapper>\u8282\u70b9,\u662f\u5426\u7f3a\u5c11<mapper></mapper>?");
        }
        mapperNode.remove(this.namespace);
        String rootXml = mapperNode.asXML();
        rootXml = rootXml.replace(MAPPER_START, EMPTY).replace(MAPPER_END, EMPTY).replace(MAPPER_EMPTY, EMPTY);
        return rootXml;
    }

    private SAXReader buildSAXReader() {
        SAXReader reader = new SAXReader();
        reader.setEncoding(ENCODE);
        try {
            reader.setFeature(SAXREADER_FEATURE, false);
        }
        catch (SAXException e) {
            LOG.error((Object)"reader.setFeature fail by ", (Throwable)e);
        }
        return reader;
    }

    public void setConfig(FastmybatisConfig config) {
        this.config = config;
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void setMapperExecutorPoolSize(int poolSize) {
        this.config.setMapperExecutorPoolSize(poolSize);
    }

    public FastmybatisConfig getConfig() {
        return this.config;
    }

    private static class MapperResource
    extends ByteArrayResource {
        private Class<?> mapperClass;

        public MapperResource(String xml, Class<?> mapperClass) throws UnsupportedEncodingException {
            super(xml.getBytes(MapperLocationsBuilder.ENCODE), mapperClass.getName());
            this.mapperClass = mapperClass;
        }

        public String getFilename() {
            return this.mapperClass.getSimpleName() + MapperLocationsBuilder.XML_SUFFIX;
        }

        public int hashCode() {
            return super.hashCode();
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof MapperResource && Arrays.equals(((MapperResource)((Object)obj)).getByteArray(), this.getByteArray());
        }
    }

    private static class MapperResourceDefinition {
        private boolean merged;
        private Resource resource;

        public MapperResourceDefinition(Resource resource) {
            this.resource = resource;
        }

        public String getFilename() {
            return this.resource.getFilename();
        }

        public boolean isMerged() {
            return this.merged;
        }

        public void setMerged(boolean merged) {
            this.merged = merged;
        }

        public Resource getResource() {
            return this.resource;
        }
    }
}

