/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.HotDeploy;
import com.gitee.fastmybatis.core.ext.MapperLocationsBuilder;
import com.gitee.fastmybatis.core.ext.exception.DatabaseConnectException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class SqlSessionFactoryBeanExt
extends SqlSessionFactoryBean {
    private static final Log LOG = LogFactory.getLog(SqlSessionFactoryBeanExt.class);
    private MapperLocationsBuilder mapperLocationsBuilder = new MapperLocationsBuilder();
    private Resource[] mapperLocations;
    private Resource[] finalMapperLocations;
    private volatile SqlSessionFactory sqlSessionFactory;
    private String basePackage;

    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
        String dbName = SqlSessionFactoryBeanExt.buildDbName(dataSource);
        this.mapperLocationsBuilder.setDbName(dbName);
    }

    public void setMapperLocations(Resource[] mapperLocations) {
        this.mapperLocations = mapperLocations;
        this.mapperLocationsBuilder.storeMapperFile(mapperLocations);
    }

    protected SqlSessionFactory buildSqlSessionFactory() throws IOException {
        Assert.notNull((Object)this.basePackage, (String)"\u5c5e\u6027 'basePackage' \u5fc5\u586b");
        Resource[] allMapperLocations = this.mapperLocationsBuilder.build(this.basePackage);
        this.finalMapperLocations = allMapperLocations;
        super.setMapperLocations(allMapperLocations);
        this.sqlSessionFactory = super.buildSqlSessionFactory();
        return this.sqlSessionFactory;
    }

    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        new HotDeploy(this).start();
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setConfig(FastmybatisConfig config) {
        this.mapperLocationsBuilder.setConfig(config);
    }

    public FastmybatisConfig getConfig() {
        return this.mapperLocationsBuilder.getConfig();
    }

    private static String buildDbName(DataSource dataSource) {
        if (dataSource == null) {
            throw new NullPointerException("dataSource \u4e0d\u80fd\u4e3anull");
        }
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            DatabaseMetaData metaData = conn.getMetaData();
            String dbName = metaData.getDatabaseProductName();
            LOG.info((Object)("\u6570\u636e\u5e93\u540d\u79f0\uff1a" + dbName));
            String string = dbName;
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new DatabaseConnectException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    LOG.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public Resource[] getMapperLocations() {
        return this.mapperLocations;
    }

    public Resource[] getFinalMapperLocations() {
        return this.finalMapperLocations;
    }

    public SqlSessionFactory getSqlSessionFactory() {
        return this.sqlSessionFactory;
    }
}

