/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.client;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.ext.code.NotEntityException;
import com.gitee.fastmybatis.core.ext.code.client.ClientParam;
import com.gitee.fastmybatis.core.ext.code.client.FileCodeGenerator;
import com.gitee.fastmybatis.core.ext.exception.MapperFileException;
import java.io.IOException;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;

public class ClassClient {
    private static Log logger = LogFactory.getLog(ClassClient.class);
    private static String EMPTY_XML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><!DOCTYPE mapper PUBLIC \"-//mybatis.org//DTD Mapper 3.0//EN\" \"http://mybatis.org/dtd/mybatis-3-mapper.dtd\"><mapper namespace=\"%s\">  <!--_ext_mapper_-->  <!--_global_vm_--> </mapper>";
    private FileCodeGenerator generator;
    private FastmybatisConfig config;

    public ClassClient(FastmybatisConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config\u4e0d\u80fd\u4e3anull");
        }
        this.config = config;
        this.generator = new FileCodeGenerator();
    }

    public String genMybatisXml(Class<?> mapperClass, String templateLocation, String globalVmLocation) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u59cb\u751f\u6210" + mapperClass.getName() + "\u5bf9\u5e94\u7684Mapper");
        }
        ClientParam param = new ClientParam();
        param.setTemplateLocation(templateLocation);
        param.setGlobalVmLocation(globalVmLocation);
        param.setMapperClass(mapperClass);
        param.setConfig(this.config);
        try {
            return this.generator.generateCode(param);
        }
        catch (NotEntityException e) {
            return String.format(EMPTY_XML, mapperClass.getName());
        }
        catch (IOException e) {
            throw new MapperFileException(e);
        }
    }
}

