/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.client;

import com.gitee.fastmybatis.core.ext.code.NotEntityException;
import com.gitee.fastmybatis.core.ext.code.client.ClientParam;
import com.gitee.fastmybatis.core.ext.code.generator.MapperContext;
import com.gitee.fastmybatis.core.ext.code.generator.TableDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.TableSelector;
import com.gitee.fastmybatis.core.ext.code.util.VelocityUtil;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class FileCodeGenerator {
    private static final String UTF8 = "UTF-8";

    public String generateCode(ClientParam clientParam) throws NotEntityException, IOException {
        InputStream templateInputStream = this.buildTemplateInputStream(clientParam);
        MapperContext sqlContext = this.buildClientSQLContextList(clientParam);
        VelocityContext context = new VelocityContext();
        TableDefinition tableDefinition = sqlContext.getTableDefinition();
        context.put("context", (Object)sqlContext);
        context.put("table", (Object)tableDefinition);
        context.put("pk", (Object)tableDefinition.getPkColumn());
        context.put("columns", tableDefinition.getTableColumns());
        context.put("allColumns", tableDefinition.getAllColumns());
        context.put("countExpression", (Object)clientParam.getCountExpression());
        context.put("associations", tableDefinition.getAssociationDefinitions());
        return VelocityUtil.generate(context, templateInputStream);
    }

    private InputStream buildTemplateInputStream(ClientParam clientParam) throws IOException {
        DefaultResourceLoader templateLoader = new DefaultResourceLoader();
        Resource vmResource = templateLoader.getResource(clientParam.getTemplateLocation());
        if (StringUtils.isNotBlank((String)clientParam.getGlobalVmLocation())) {
            DefaultResourceLoader globalVmResourceLoader = new DefaultResourceLoader();
            Resource globalVmResource = globalVmResourceLoader.getResource(clientParam.getGlobalVmLocation());
            return this.mergeGlobalVm(vmResource, globalVmResource, clientParam.getGlobalVmPlaceholder());
        }
        return vmResource.getInputStream();
    }

    private InputStream mergeGlobalVm(Resource vmResource, Resource globalVmResource, String placeholder) throws IOException {
        String vmContent = IOUtils.toString((InputStream)vmResource.getInputStream(), (String)UTF8);
        String globalVmContent = IOUtils.toString((InputStream)globalVmResource.getInputStream(), (String)UTF8);
        String finalContent = vmContent.replace(placeholder, globalVmContent);
        return IOUtils.toInputStream((String)finalContent, (String)UTF8);
    }

    private MapperContext buildClientSQLContextList(ClientParam clientParam) throws NotEntityException {
        Class<?> entityClass = clientParam.getEntityClass();
        if (entityClass == Object.class || entityClass == Void.class) {
            throw new NotEntityException();
        }
        TableSelector tableSelector = new TableSelector(entityClass, clientParam.getConfig());
        TableDefinition tableDefinition = tableSelector.getTableDefinition();
        MapperContext context = new MapperContext(tableDefinition);
        String namespace = this.buildNamespace(clientParam.getMapperClass());
        context.setClassName(entityClass.getName());
        context.setClassSimpleName(entityClass.getSimpleName());
        context.setPackageName(entityClass.getPackage().getName());
        context.setNamespace(namespace);
        return context;
    }

    private String buildNamespace(Class<?> mapperClass) {
        return mapperClass.getName();
    }
}

