/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.generator;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.annotation.LazyFetch;
import com.gitee.fastmybatis.core.annotation.LogicDelete;
import com.gitee.fastmybatis.core.ext.ExtContext;
import com.gitee.fastmybatis.core.ext.code.generator.AssociationDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.ColumnDefinition;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.ext.code.util.JavaTypeUtil;
import com.gitee.fastmybatis.core.ext.code.util.ReflectUtil;
import com.gitee.fastmybatis.core.ext.exception.GenCodeException;
import com.gitee.fastmybatis.core.handler.BaseEnum;
import com.gitee.fastmybatis.core.handler.BaseFill;
import com.gitee.fastmybatis.core.handler.EnumTypeHandler;
import com.gitee.fastmybatis.core.handler.FillType;
import com.gitee.fastmybatis.core.util.ClassUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Version;
import org.apache.commons.lang.StringUtils;

public class ColumnSelector {
    private static final String UUID_NAME = "uuid";
    private static final String INCREMENT_NAME = "increment";
    private static final String STRING_TYPE = "String";
    private static final String SELECT_GET = "%s.getById";
    private Class<?> entityClass;
    private FastmybatisConfig config;

    public ColumnSelector(Class<?> entityClass, FastmybatisConfig config) {
        this.entityClass = entityClass;
        this.config = config;
    }

    private String getColumnType(Field field) {
        String columnType = field.getType().getSimpleName();
        if ("Object".equals(columnType)) {
            columnType = ClassUtil.getSuperClassGenricType(this.entityClass, 0).getSimpleName();
        }
        return columnType;
    }

    private String getColumnFullType(Field field) {
        String fullType = field.getType().getName();
        if ("java.lang.Object".equals(fullType)) {
            fullType = ClassUtil.getSuperClassGenricType(this.entityClass, 0).getSimpleName();
        }
        return fullType;
    }

    private boolean isEnum(Field field) {
        Class<?> enumType = field.getType();
        boolean isEnum = enumType.isEnum();
        if (isEnum) {
            this.checkEnumn(enumType);
        }
        return isEnum;
    }

    private void checkEnumn(Class<?> enumType) {
        Class<?>[] arr;
        boolean isBaseEnum = false;
        Class<BaseEnum> baseEnumClass = BaseEnum.class;
        for (Class<?> type : arr = enumType.getInterfaces()) {
            if (!type.equals(baseEnumClass)) continue;
            isBaseEnum = true;
            break;
        }
        if (!isBaseEnum) {
            throw new GenCodeException("\u679a\u4e3e\u7c7b\uff1a" + enumType.getName() + "\u5fc5\u987b\u5b9e\u73b0" + baseEnumClass.getName() + "\u63a5\u53e3");
        }
    }

    private String getColumnName(Field field) {
        Column columnAnno = field.getAnnotation(Column.class);
        if (columnAnno != null) {
            String columnName = columnAnno.name();
            if ("".equals(columnName)) {
                throw new IllegalArgumentException(field.getName() + "\u6ce8\u89e3@Column(name=\"\")name\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a");
            }
            return columnName;
        }
        String javaFieldName = field.getName();
        if (this.config.isCamel2underline()) {
            return FieldUtil.camelToUnderline(javaFieldName);
        }
        return javaFieldName;
    }

    private boolean isPK(Field field) {
        return field.getAnnotation(Id.class) != null;
    }

    private boolean isIdentity(GeneratedValue generatedValue) {
        String generator = generatedValue.generator().toLowerCase();
        return generatedValue.strategy() == GenerationType.IDENTITY || generator.contains(INCREMENT_NAME);
    }

    private boolean isUuid(Field field, String columnType, GeneratedValue generatedValue) {
        String generator = generatedValue.generator().toLowerCase();
        boolean isUuid = generator.contains(UUID_NAME);
        boolean isStringType = STRING_TYPE.equals(columnType);
        if (isUuid && !isStringType) {
            String columnName = this.getColumnName(field);
            throw new GenCodeException("\u5b57\u6bb5[" + columnName + "]\u5b9a\u4e49\u4e86UUID\u7b56\u7565\uff0c\u4f46\u7c7b\u578b\u4e0d\u662fString\uff0c\u5b9e\u9645\u7c7b\u578b\u4e3a\uff1a" + columnType);
        }
        return isUuid;
    }

    private boolean isSequence(GeneratedValue generatedValue) {
        GenerationType strategy = generatedValue.strategy();
        return strategy == GenerationType.SEQUENCE;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        List<Field> fields = ReflectUtil.getDeclaredFields(this.entityClass);
        ArrayList<ColumnDefinition> columnDefinitionList = new ArrayList<ColumnDefinition>(fields.size());
        for (Field field : fields) {
            ColumnDefinition columnDefinition = this.buildColumnDefinition(field);
            if (columnDefinition == null) continue;
            columnDefinitionList.add(columnDefinition);
        }
        return columnDefinitionList;
    }

    public List<AssociationDefinition> getAssociationDefinitions() {
        List<Field> fields = ReflectUtil.getDeclaredFields(this.entityClass);
        ArrayList<AssociationDefinition> associations = new ArrayList<AssociationDefinition>(8);
        for (Field field : fields) {
            AssociationDefinition associationDefinition = this.buildAssociationDefinition(field);
            if (associationDefinition == null) continue;
            associations.add(associationDefinition);
        }
        return associations;
    }

    protected AssociationDefinition buildAssociationDefinition(Field field) {
        boolean isTransient = FieldUtil.isTransientField(field);
        if (isTransient) {
            return null;
        }
        Class<?> clazz = field.getType();
        Table table = clazz.getAnnotation(Table.class);
        if (table == null) {
            return null;
        }
        String column = this.getLazyEntityColumnName(field);
        String property = field.getName();
        Class<?> mapperClass = ExtContext.getMapperClass(clazz);
        String namespace = mapperClass.getName();
        String select = String.format(SELECT_GET, namespace);
        AssociationDefinition associationDefinition = new AssociationDefinition();
        associationDefinition.setColumn(column);
        associationDefinition.setProperty(property);
        associationDefinition.setSelect(select);
        return associationDefinition;
    }

    private String getLazyEntityColumnName(Field field) {
        String columnName;
        LazyFetch lazyFetch = field.getAnnotation(LazyFetch.class);
        if (lazyFetch != null) {
            columnName = lazyFetch.column();
        } else {
            Column columnAnno = field.getAnnotation(Column.class);
            if (columnAnno == null) {
                throw new IllegalArgumentException("\u61d2\u52a0\u8f7d\u5c5e\u6027[" + field.getName() + "]\u5fc5\u987b\u6307\u5b9a@LazyFetch\u6ce8\u89e3");
            }
            columnName = columnAnno.name();
        }
        if ("".equals(columnName)) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9a\u61d2\u52a0\u8f7d\u5bf9\u8c61\u6570\u636e\u5e93\u5b57\u6bb5\u540d\uff1a" + field.getName() + "\uff0c\u662f\u5426\u7f3a\u5c11@LazyFetch.name\u5c5e\u6027?");
        }
        return columnName;
    }

    protected ColumnDefinition buildColumnDefinition(Field field) {
        ColumnDefinition columnDefinition = new ColumnDefinition();
        boolean isTransient = FieldUtil.isTransientField(field);
        columnDefinition.setTransient(isTransient);
        String columnName = this.getColumnName(field);
        String columnType = this.getColumnType(field);
        String fullType = this.getColumnFullType(field);
        boolean isEnum = this.isEnum(field);
        if (!isEnum && !JavaTypeUtil.isJavaType(columnType)) {
            return null;
        }
        columnDefinition.setJavaFieldName(field.getName());
        columnDefinition.setColumnName(columnName);
        columnDefinition.setType(columnType);
        columnDefinition.setFullType(fullType);
        columnDefinition.setEnum(isEnum);
        columnDefinition.setIgnoreUpdate(this.config.getIgnoreUpdateColumns().contains(columnName));
        if (isEnum) {
            columnDefinition.setTypeHandler(EnumTypeHandler.class.getName());
            columnDefinition.setFillType(FillType.UPDATE);
        }
        boolean isPk = this.isPK(field);
        columnDefinition.setIsPk(isPk);
        if (isPk) {
            GeneratedValue generatedValue = field.getAnnotation(GeneratedValue.class);
            if (generatedValue == null) {
                throw new GenCodeException("class[" + this.entityClass.getName() + "." + columnName + "]\u672a\u8bbe\u7f6e\u4e3b\u952e\u7b56\u7565\uff0c\u662f\u5426\u7f3a\u5c11@GeneratedValue\u6ce8\u89e3");
            }
            if (this.isIdentity(generatedValue)) {
                columnDefinition.setIsIdentity(true);
            } else if (this.isSequence(generatedValue)) {
                SequenceGenerator sequenceGenerator = field.getAnnotation(SequenceGenerator.class);
                if (sequenceGenerator == null) {
                    throw new GenCodeException("class[" + this.entityClass.getName() + "." + columnName + "]\u5b9a\u4e49\u4e86sequence\u7b56\u7565\uff0c\u4f46\u7f3a\u5c11@SequenceGenerator\u6ce8\u89e3");
                }
                String sequenceName = sequenceGenerator.sequenceName();
                if (StringUtils.isBlank((String)sequenceName)) {
                    throw new GenCodeException("class[" + this.entityClass.getName() + "." + columnName + "]\u7f3a\u5c11@SequenceGenerator.sequenceName\u5c5e\u6027");
                }
                columnDefinition.setIsSequence(true);
                columnDefinition.setSequenceName(sequenceName);
            } else {
                boolean isUuid = this.isUuid(field, columnType, generatedValue);
                columnDefinition.setIsUuid(isUuid);
                columnDefinition.setIsAuto(!isUuid);
            }
        }
        boolean isVersionColumn = this.isVersionColumn(field);
        columnDefinition.setIsVersion(isVersionColumn);
        this.bindLogicDeleteColumnInfo(columnDefinition, field);
        if (!isTransient) {
            this.bindFill(columnDefinition, field);
        }
        return columnDefinition;
    }

    private void bindLogicDeleteColumnInfo(ColumnDefinition columnDefinition, Field field) {
        LogicDelete logicDelete = field.getAnnotation(LogicDelete.class);
        boolean isLogicDelete = logicDelete != null;
        columnDefinition.setIsLogicDelete(isLogicDelete);
        if (isLogicDelete) {
            Object delVal = null;
            Object notDelVal = null;
            String deleteValue = logicDelete.deleteValue();
            String notDeleteValue = logicDelete.notDeleteValue();
            if ("".equals(deleteValue)) {
                deleteValue = this.config.getLogicDeleteValue();
            }
            if ("".equals(notDeleteValue)) {
                notDeleteValue = this.config.getLogicNotDeleteValue();
            }
            delVal = StringUtils.isNumeric((String)deleteValue) ? Integer.valueOf(deleteValue) : deleteValue;
            columnDefinition.setLogicDeleteValue(delVal);
            notDelVal = StringUtils.isNumeric((String)notDeleteValue) ? Integer.valueOf(notDeleteValue) : notDeleteValue;
            columnDefinition.setLogicNotDeleteValue(notDelVal);
        }
    }

    private boolean isVersionColumn(Field field) {
        Version versionAnno = field.getAnnotation(Version.class);
        return versionAnno != null;
    }

    private void bindFill(ColumnDefinition columnDefinition, Field field) {
        String columnName = columnDefinition.getColumnName();
        BaseFill<?> fill = this.config.getFill(this.entityClass, field, columnName);
        if (fill != null) {
            FillType fillType = fill.getFillType();
            columnDefinition.setTypeHandler(((Object)fill).getClass().getName());
            columnDefinition.setFillType(fillType);
            columnDefinition.setIsCustomFill(fillType == FillType.INSERT || fillType == FillType.UPDATE);
        }
    }
}

