/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.generator;

import com.gitee.fastmybatis.core.ext.code.generator.AssociationDefinition;
import com.gitee.fastmybatis.core.ext.code.generator.ColumnDefinition;
import com.gitee.fastmybatis.core.ext.exception.GenCodeException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class TableDefinition {
    private String schema;
    private String tableName;
    private String comment;
    private List<ColumnDefinition> columnDefinitions = Collections.emptyList();
    private ColumnDefinition pkColumn;
    private ColumnDefinition versionColumn;
    private ColumnDefinition logicDeleteColumn;
    private List<AssociationDefinition> associationDefinitions;

    public TableDefinition() {
    }

    public TableDefinition(String tableName) {
        this.tableName = tableName;
    }

    public List<ColumnDefinition> getTableColumns() {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        ArrayList<ColumnDefinition> ret = new ArrayList<ColumnDefinition>();
        for (ColumnDefinition columnDefinition : columns) {
            if (columnDefinition.isTransient()) continue;
            ret.add(columnDefinition);
        }
        return ret;
    }

    public List<ColumnDefinition> getAllColumns() {
        return this.getColumnDefinitions();
    }

    public boolean getHasDateField() {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        for (ColumnDefinition definition : columns) {
            if (!"Date".equals(definition.getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasBigDecimalField() {
        List<ColumnDefinition> columns = this.getColumnDefinitions();
        for (ColumnDefinition definition : columns) {
            if (!"BigDecimal".equals(definition.getJavaType())) continue;
            return true;
        }
        return false;
    }

    public boolean getHasVersionColumn() {
        return this.versionColumn != null;
    }

    public boolean getHasLogicDeleteColumn() {
        return this.logicDeleteColumn != null;
    }

    public ColumnDefinition getPkColumn() {
        return this.pkColumn;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public List<ColumnDefinition> getColumnDefinitions() {
        return this.columnDefinitions;
    }

    public void setColumnDefinitions(List<ColumnDefinition> columnDefinitions) {
        this.columnDefinitions = columnDefinitions;
        this.initPKColumn(columnDefinitions);
        this.initVersionJavaColumn(columnDefinitions);
        this.initDeleteJavaColumn(columnDefinitions);
        this.initOrderIndex(columnDefinitions);
    }

    private void initOrderIndex(List<ColumnDefinition> columnDefinitions) {
        Collections.sort(columnDefinitions, new Comparator<ColumnDefinition>(){

            @Override
            public int compare(ColumnDefinition o1, ColumnDefinition o2) {
                return Integer.compare(o1.getOrderIndex(), o2.getOrderIndex());
            }
        });
    }

    private void initPKColumn(List<ColumnDefinition> columnDefinitions) {
        for (ColumnDefinition column : columnDefinitions) {
            if (!column.getIsPk()) continue;
            column.setOrderIndex(0);
            this.setPkColumn(column);
            break;
        }
    }

    private void initVersionJavaColumn(List<ColumnDefinition> columnDefinitions) {
        for (ColumnDefinition column : columnDefinitions) {
            if (!column.getIsVersion()) continue;
            this.setVersionColumn(column);
            break;
        }
    }

    private void initDeleteJavaColumn(List<ColumnDefinition> columnDefinitions) {
        int count = 0;
        for (ColumnDefinition column : columnDefinitions) {
            if (!column.getIsLogicDelete()) continue;
            if (count == 1) {
                throw new GenCodeException(column.getJavaFieldName() + "\u5b57\u6bb5\u91cd\u590d\u5b9a\u4e49@LogicDelete.\u786e\u4fdd\u5b9e\u4f53\u7c7b\u4e2d\u53ea\u6709\u4e00\u4e2a@LogicDelete\u6ce8\u89e3");
            }
            this.setLogicDeleteColumn(column);
            ++count;
        }
    }

    public ColumnDefinition getVersionColumn() {
        return this.versionColumn;
    }

    public void setVersionColumn(ColumnDefinition versionColumn) {
        this.versionColumn = versionColumn;
    }

    public void setPkColumn(ColumnDefinition pkColumn) {
        this.pkColumn = pkColumn;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public ColumnDefinition getLogicDeleteColumn() {
        return this.logicDeleteColumn;
    }

    public void setLogicDeleteColumn(ColumnDefinition logicDeleteColumn) {
        this.logicDeleteColumn = logicDeleteColumn;
    }

    public List<AssociationDefinition> getAssociationDefinitions() {
        return this.associationDefinitions;
    }

    public void setAssociationDefinitions(List<AssociationDefinition> associationDefinitions) {
        this.associationDefinitions = associationDefinitions;
    }
}

