/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.ext.code.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.persistence.Transient;

public class FieldUtil {
    private static final String DOT = ".";
    public static final char UNDERLINE = '_';

    private FieldUtil() {
    }

    public static String dotFilter(String field) {
        if (FieldUtil.isNotEmpty(field) && field.indexOf(DOT) > -1) {
            String[] words = field.split("\\.");
            StringBuilder ret = new StringBuilder();
            for (String str : words) {
                ret.append(FieldUtil.upperFirstLetter(str));
            }
            return ret.toString();
        }
        return field;
    }

    public static String upperFirstLetter(String str) {
        if (FieldUtil.isNotEmpty(str)) {
            String firstUpper = String.valueOf(str.charAt(0)).toUpperCase();
            str = firstUpper + str.substring(1);
        }
        return str;
    }

    public static String lowerFirstLetter(String str) {
        if (FieldUtil.isNotEmpty(str)) {
            String firstLower = String.valueOf(str.charAt(0)).toLowerCase();
            str = firstLower + str.substring(1);
        }
        return str;
    }

    public static String camelToUnderline(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            boolean needToLower;
            char c = param.charAt(i);
            int preIndex = i - 1;
            int nextIndex = i + 1;
            boolean bl = needToLower = Character.isUpperCase(c) && preIndex > 0 && Character.isLowerCase(param.charAt(preIndex)) || Character.isUpperCase(c) && nextIndex < len && Character.isLowerCase(param.charAt(nextIndex));
            if (needToLower) {
                if (i > 0) {
                    sb.append('_');
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String underlineToCamel(String param) {
        if (param == null || "".equals(param.trim())) {
            return "";
        }
        int len = param.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = param.charAt(i);
            if (c == '_') {
                if (++i >= len) continue;
                sb.append(Character.toUpperCase(param.charAt(i)));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static boolean isTransientField(Field field) {
        Transient transientAnno = field.getAnnotation(Transient.class);
        return transientAnno != null ? true : Modifier.isTransient(field.getModifiers());
    }

    private static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    private static boolean isNotEmpty(String s) {
        return !FieldUtil.isEmpty(s);
    }
}

