/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.expression;

import com.gitee.fastmybatis.core.query.expression.ExpressionListable;
import com.gitee.fastmybatis.core.query.expression.ValueConvert;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class ListExpression
implements ExpressionListable {
    private String column = "";
    private String equal = "IN";
    private Collection<?> value = Collections.emptyList();
    private String joint = "AND";
    private int index = Integer.MAX_VALUE;

    public ListExpression(String joint, String column, String equal, Collection<?> value) {
        if (value == null || value.isEmpty()) {
            throw new IllegalArgumentException("ListExpression\u6784\u9020\u65b9\u6cd5\u53c2\u6570value\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.joint = joint;
        this.equal = equal;
        this.column = column;
        this.value = value;
    }

    public <T> ListExpression(String joint, String column, String equal, Collection<T> value, ValueConvert<T> valueConvert) {
        this(joint, column, equal, ListExpression.buildValueConvert(value, valueConvert));
    }

    public <T> ListExpression(String joint, String column, String equal, T[] value, ValueConvert<T> valueConvert) {
        this(joint, column, equal, Arrays.asList(value), valueConvert);
    }

    public ListExpression(String joint, String column, String equal, Object[] value) {
        this(joint, column, equal, Arrays.asList(value));
    }

    private static <T> Collection<?> buildValueConvert(Collection<T> value, ValueConvert<T> valueConvert) {
        if (value == null) {
            return Collections.emptyList();
        }
        if (valueConvert == null) {
            throw new NullPointerException("\u53c2\u6570ValueConvert\u4e0d\u80fd\u4e3anull");
        }
        HashSet<Object> newSet = new HashSet<Object>(value.size());
        for (T obj : value) {
            newSet.add(valueConvert.convert(obj));
        }
        return newSet;
    }

    @Override
    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    @Override
    public String getEqual() {
        return this.equal;
    }

    public void setEqual(String equal) {
        this.equal = equal;
    }

    @Override
    public Collection<?> getValue() {
        return this.value;
    }

    public void setValue(Collection<?> value) {
        this.value = value;
    }

    @Override
    public String getJoint() {
        return this.joint;
    }

    public void setJoint(String joint) {
        this.joint = joint;
    }

    @Override
    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int index() {
        return this.index;
    }
}

