/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.expression.builder;

import com.gitee.fastmybatis.core.exception.QueryException;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import com.gitee.fastmybatis.core.query.ConditionValueHandler;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.annotation.ConditionConfig;
import com.gitee.fastmybatis.core.query.expression.Expression;
import com.gitee.fastmybatis.core.query.expression.Expressions;
import com.gitee.fastmybatis.core.query.expression.builder.ExpressionBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;

public class ConditionBuilder {
    private static final Log LOG = LogFactory.getLog(ConditionBuilder.class);
    private static final String PREFIX_GET = "get";
    private static final String GETCLASS_NAME = "getClass";
    private static ConditionBuilder underlineFieldBuilder = new ConditionBuilder(true);
    private static ConditionBuilder camelFieldBuilder = new ConditionBuilder(false);
    private static Map<String, String> fieldToColumnNameMap = new HashMap<String, String>(16);
    private static Map<String, ConditionValueHandler> conditionValueHandlerMap = new HashMap<String, ConditionValueHandler>(16);
    private static Map<String, Condition> methodConditionCache = new HashMap<String, Condition>(16);
    private boolean camel2underline = Boolean.TRUE;

    public ConditionBuilder() {
    }

    public ConditionBuilder(boolean camel2underline) {
        this.camel2underline = camel2underline;
    }

    public static ConditionBuilder getUnderlineFieldBuilder() {
        return underlineFieldBuilder;
    }

    public static ConditionBuilder getCamelFieldBuilder() {
        return camelFieldBuilder;
    }

    public List<Expression> buildExpressions(Object pojo) {
        Method[] methods;
        Assert.notNull((Object)pojo, (String)"buildExpressions(Object pojo) pojo can't be null.");
        ArrayList<Expression> expList = new ArrayList<Expression>();
        Class<?> clazz = pojo.getClass();
        ConditionConfig conditionConfig = clazz.getAnnotation(ConditionConfig.class);
        Object[] ignoreFields = conditionConfig == null ? null : conditionConfig.ignoreFields();
        for (Method method : methods = clazz.getMethods()) {
            try {
                String columnName;
                Expression expression;
                Condition condition;
                Object value;
                if (!ConditionBuilder.couldBuildExpression(method)) continue;
                String fieldName = this.buildFieldName(method);
                if (ignoreFields != null && ArrayUtils.contains((Object[])ignoreFields, (Object)fieldName) || (value = this.getMethodValue(method, fieldName, condition = this.findCondition(method, fieldName), pojo)) == null || (expression = this.buildExpression(condition, columnName = this.getColumnName(method, condition, conditionConfig), value)) == null) continue;
                expList.add(expression);
            }
            catch (Exception e) {
                LOG.error((Object)("\u6784\u5efa\u8868\u8fbe\u5f0f\u5931\u8d25\uff0cmenthod:" + method), (Throwable)e);
                throw new QueryException(e);
            }
        }
        return expList;
    }

    private Expression buildExpression(Condition condition, String columnName, Object value) {
        Expression expression = condition == null ? (value.getClass().isArray() ? Expressions.in(columnName, (Object[])value) : (value instanceof Collection ? Expressions.in(columnName, (Collection)value) : Expressions.eq(columnName, value))) : ExpressionBuilder.buildExpression(condition, columnName, value);
        return expression;
    }

    private Condition findCondition(Method method, String fieldName) {
        String key = method.toString();
        Condition annotation = methodConditionCache.get(key);
        if (annotation == null && (annotation = method.getAnnotation(Condition.class)) == null) {
            Class<?> clazz = method.getDeclaringClass();
            Field field = ReflectionUtils.findField(clazz, (String)fieldName);
            if (field != null) {
                annotation = field.getAnnotation(Condition.class);
            }
            if (annotation != null) {
                methodConditionCache.put(key, annotation);
            }
        }
        return annotation;
    }

    private String getColumnName(Method method, Condition condition, ConditionConfig conditionConfig) {
        String key = method.toString();
        String columnName = fieldToColumnNameMap.get(key);
        if (columnName != null) {
            return columnName;
        }
        columnName = this.buildColumnNameByCondition(condition);
        if (columnName == null || "".equals(columnName)) {
            columnName = this.buildColumnNameByMethod(method, conditionConfig);
        }
        fieldToColumnNameMap.put(key, columnName);
        return columnName;
    }

    private String buildColumnNameByMethod(Method method, ConditionConfig conditionConfig) {
        boolean camel2underline;
        String columnName = this.buildColumnName(method);
        boolean bl = camel2underline = conditionConfig == null ? this.camel2underline : conditionConfig.camel2underline();
        if (camel2underline) {
            columnName = FieldUtil.camelToUnderline(columnName);
        }
        return columnName;
    }

    private String buildColumnNameByCondition(Condition condition) {
        String column;
        String columnName = null;
        if (condition != null && !"".equals(column = condition.column())) {
            columnName = column;
        }
        return columnName;
    }

    private Object getMethodValue(Method method, String fieldName, Condition condition, Object pojo) throws InvocationTargetException, IllegalAccessException {
        Class<? extends ConditionValueHandler> handlerClass;
        Object fieldValue = method.invoke(pojo, new Object[0]);
        Class<? extends ConditionValueHandler> clazz = handlerClass = condition == null ? null : condition.handlerClass();
        if (handlerClass != null && handlerClass != ConditionValueHandler.DefaultConditionValueHandler.class) {
            try {
                ConditionValueHandler conditionValueHandler = this.getValueHandler(handlerClass);
                fieldValue = conditionValueHandler.getConditionValue(fieldValue, fieldName, pojo);
            }
            catch (Exception e) {
                LOG.error((Object)("handlerClass.newInstance\u51fa\u9519\uff0cclass:" + handlerClass.getName()), (Throwable)e);
                throw new QueryException("\u5b9e\u4f8b\u5316ConditionValueHandler\u51fa\u9519\uff0cfield:" + method);
            }
        }
        return fieldValue;
    }

    private ConditionValueHandler getValueHandler(Class<? extends ConditionValueHandler> handlerClass) throws IllegalAccessException, InstantiationException {
        String key = handlerClass.getName();
        ConditionValueHandler conditionValueHandler = conditionValueHandlerMap.get(key);
        if (conditionValueHandler == null) {
            conditionValueHandler = handlerClass.newInstance();
            conditionValueHandlerMap.put(key, conditionValueHandler);
        }
        return conditionValueHandler;
    }

    private String buildColumnName(Method method) {
        String getMethodName = method.getName();
        String columnName = getMethodName.substring(3);
        columnName = FieldUtil.lowerFirstLetter(columnName);
        return columnName;
    }

    private String buildFieldName(Method method) {
        String getMethodName = method.getName();
        String columnName = getMethodName.substring(3);
        columnName = FieldUtil.lowerFirstLetter(columnName);
        return columnName;
    }

    private static boolean couldBuildExpression(Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        String methodName = method.getName();
        return !GETCLASS_NAME.equals(methodName) && methodName.startsWith(PREFIX_GET);
    }
}

