/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.expression.builder;

import com.gitee.fastmybatis.core.FastmybatisConfig;
import com.gitee.fastmybatis.core.query.Operator;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.expression.Expression;
import com.gitee.fastmybatis.core.query.expression.Expressions;
import com.gitee.fastmybatis.core.query.expression.builder.factory.ExpressionFactory;
import com.gitee.fastmybatis.core.util.ClassUtil;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class ExpressionBuilder {
    private static Map<Operator, ExpressionFactory> factoryMap = new HashMap<Operator, ExpressionFactory>();

    public static Expression buildExpression(Condition annotation, String columnName, Object value) {
        boolean ignoreEmptyString;
        if (annotation == null) {
            throw new NullPointerException("Condition\u4e0d\u80fd\u4e3anull");
        }
        if (annotation.ignore()) {
            return null;
        }
        Object[] ignoreValue = annotation.ignoreValue();
        if (ArrayUtils.contains((Object[])ignoreValue, (Object)String.valueOf(value))) {
            return null;
        }
        boolean bl = ignoreEmptyString = annotation.ignoreEmptyString() || FastmybatisConfig.ignoreEmptyString;
        if (ignoreEmptyString && "".equals(value)) {
            return null;
        }
        Operator operator = annotation.operator();
        if (operator == Operator.nil) {
            operator = ClassUtil.isArrayOrCollection(value) ? Operator.in : Operator.eq;
        }
        ExpressionFactory expressionFactory = factoryMap.get((Object)operator);
        String column = annotation.column();
        if (column == null || "".equals(column.trim())) {
            column = columnName;
        }
        Expression expression = expressionFactory.buildExpression(annotation.joint(), column, operator, value);
        expression.setIndex(annotation.index());
        return expression;
    }

    static {
        factoryMap.put(Operator.eq, Expressions.VALUE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.notEq, Expressions.VALUE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.gt, Expressions.VALUE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.ge, Expressions.VALUE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.lt, Expressions.VALUE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.le, Expressions.VALUE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.like, Expressions.LIKE_EXPRESSION_FACTORY);
        factoryMap.put(Operator.likeLeft, Expressions.LIKE_LEFT_EXPRESSION_FACTORY);
        factoryMap.put(Operator.likeRight, Expressions.LIKE_RIGHT_EXPRESSION_FACTORY);
        factoryMap.put(Operator.in, Expressions.LIST_EXPRESSION_FACTORY);
        factoryMap.put(Operator.notIn, Expressions.LIST_EXPRESSION_FACTORY);
    }
}

