/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.param;

import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.param.BaseParam;
import com.gitee.fastmybatis.core.query.param.SchPageableParam;

public class PageParam
extends BaseParam
implements SchPageableParam {
    private int pageIndex = 1;
    private int pageSize = 20;

    @Override
    public Query toQuery() {
        return super.toQuery().addPaginationInfo(this);
    }

    @Override
    @Condition(ignore=true)
    public int getStart() {
        return (this.getPageIndex() - 1) * this.getPageSize();
    }

    @Override
    @Condition(ignore=true)
    public int getLimit() {
        return this.getPageSize();
    }

    @Condition(ignore=true)
    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Condition(ignore=true)
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }
}

