/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.query.param;

import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.annotation.Condition;
import com.gitee.fastmybatis.core.query.param.BaseParam;
import com.gitee.fastmybatis.core.query.param.SchPageableParam;
import com.gitee.fastmybatis.core.query.param.SchSortableParam;

public class PageSortParam
extends BaseParam
implements SchPageableParam,
SchSortableParam {
    private int pageIndex = 1;
    private int pageSize = 20;
    private String sort;
    private String order;

    @Override
    public Query toQuery() {
        return super.toQuery().addPaginationInfo(this).addSortInfo(this);
    }

    @Override
    @Condition(ignore=true)
    public String getSortname() {
        return this.sort;
    }

    @Override
    @Condition(ignore=true)
    public String getSortorder() {
        return this.order;
    }

    @Override
    @Condition(ignore=true)
    public int getStart() {
        return (this.getPageIndex() - 1) * this.getPageSize();
    }

    @Override
    @Condition(ignore=true)
    public int getLimit() {
        return this.getPageSize();
    }

    @Condition(ignore=true)
    public int getPageIndex() {
        return this.pageIndex;
    }

    public void setPageIndex(int pageIndex) {
        this.pageIndex = pageIndex;
    }

    @Condition(ignore=true)
    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    @Condition(ignore=true)
    public String getSort() {
        return this.sort;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    @Condition(ignore=true)
    public String getOrder() {
        return this.order;
    }

    public void setOrder(String order) {
        this.order = order;
    }

    @Override
    @Condition(ignore=true)
    public String getDBSortname() {
        return this.sort;
    }
}

