/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.util.MyBeanUtil;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class ClassUtil {
    private ClassUtil() {
    }

    public static Class<?> getSuperClassGenricType(Class<?> clazz, int index) throws IndexOutOfBoundsException {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Class<?> getSuperInterfaceGenricType(Class<?> clazz, int index) {
        Type[] interfacesTypes = clazz.getGenericInterfaces();
        if (interfacesTypes.length == 0) {
            return Object.class;
        }
        Type firstInterface = interfacesTypes[0];
        Type[] params = ((ParameterizedType)firstInterface).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static String getClassSimpleName(Class<?> clazz) {
        String className = clazz.getSimpleName();
        return className.substring(0, 1).toLowerCase() + className.substring(1);
    }

    @Deprecated
    public static Map<String, Object> pojoToMap(Object pojo) {
        return MyBeanUtil.pojoToMap(pojo);
    }

    @Deprecated
    public static <T> List<T> mapListToObjList(List<Map<String, Object>> list, Class<T> pojoClass) {
        return MyBeanUtil.mapListToObjList(list, pojoClass);
    }

    @Deprecated
    public static <T> T mapToPojo(Map<String, Object> map, Class<T> pojoClass) {
        return MyBeanUtil.mapToPojo(map, pojoClass);
    }

    public static boolean isArrayOrCollection(Object value) {
        boolean ret = false;
        if (value.getClass().isArray()) {
            ret = true;
        } else if (value instanceof Collection) {
            ret = true;
        }
        return ret;
    }
}

