/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.gitee.fastmybatis.core.PageInfo;
import com.gitee.fastmybatis.core.PageResult;
import com.gitee.fastmybatis.core.exception.QueryException;
import com.gitee.fastmybatis.core.mapper.SchMapper;
import com.gitee.fastmybatis.core.query.Query;
import com.gitee.fastmybatis.core.query.param.BaseParam;
import com.gitee.fastmybatis.core.support.PageEasyui;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;

public class MapperUtil {
    private MapperUtil() {
    }

    public static <E, T> PageEasyui<T> queryForEasyuiDatagrid(SchMapper<E, ?> mapper, Query query, Class<T> clazz) {
        PageEasyui<Object> pageInfo = MapperUtil.queryForEasyuiDatagrid(mapper, query);
        List<E> list = pageInfo.getRows();
        if (CollectionUtils.isNotEmpty(list)) {
            ArrayList<Object> newList = new ArrayList<Object>(list.size());
            try {
                for (E element : list) {
                    if (clazz == element.getClass()) {
                        newList.add(element);
                        continue;
                    }
                    T t = clazz.newInstance();
                    BeanUtils.copyProperties(element, t);
                    newList.add(t);
                }
                pageInfo.setList(newList);
            }
            catch (Exception e) {
                throw new QueryException(e);
            }
        } else {
            pageInfo.setList(Collections.emptyList());
        }
        return pageInfo;
    }

    public static <E> PageEasyui<E> queryForEasyuiDatagrid(SchMapper<E, ?> mapper, Query query) {
        return MapperUtil.query(mapper, query, PageEasyui.class);
    }

    private static int calcPageCount(long total, int pageSize) {
        return (int)(pageSize == 0 ? 1L : (total + (long)pageSize - 1L) / (long)pageSize);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, Object bean) {
        return MapperUtil.query(mapper, Query.build(bean), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, BaseParam searchParam) {
        return MapperUtil.query(mapper, Query.build(searchParam), PageInfo.class);
    }

    public static <Entity> PageInfo<Entity> query(SchMapper<Entity, ?> mapper, Query query) {
        return MapperUtil.query(mapper, query, PageInfo.class);
    }

    public static <Entity, T extends PageResult<Entity>> T query(SchMapper<Entity, ?> mapper, Query query, Class<T> pageResultClass) {
        PageResult result = null;
        try {
            result = (PageResult)pageResultClass.newInstance();
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
        try {
            int pageCount = 0;
            long total = 0L;
            List<Object> list = Collections.emptyList();
            if (query.getIsQueryAll()) {
                list = mapper.list(query);
                total = list.size();
                if (total > 0L) {
                    pageCount = 1;
                }
            } else {
                total = query.getIsSetTotal() ? (long)query.getTotal() : mapper.getCount(query);
                if (total > 0L) {
                    list = mapper.list(query);
                    int start = query.getStart();
                    int pageSize = query.getLimit();
                    int pageIndex = start / pageSize + 1;
                    result.setStart(start);
                    result.setPageIndex(pageIndex);
                    result.setPageSize(pageSize);
                    pageCount = MapperUtil.calcPageCount(total, pageSize);
                }
            }
            result.setList(list);
            result.setTotal(total);
            result.setPageCount(pageCount);
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
        return (T)result;
    }
}

