/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.fastmybatis.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.gitee.fastmybatis.core.exception.QueryException;
import com.gitee.fastmybatis.core.ext.code.util.FieldUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.FatalBeanException;
import org.springframework.util.Assert;

public class MyBeanUtil
extends BeanUtils {
    private static final String PREFIX_GET = "get";
    private static final String GETCLASS_NAME = "getClass";
    private static Map<String, List<Method>> objGetMethods = new ConcurrentHashMap<String, List<Method>>(16);

    public static void copyPropertiesIgnoreNull(Object source, Object target) throws BeansException {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        for (PropertyDescriptor targetPd : targetPds = MyBeanUtil.getPropertyDescriptors(actualEditable)) {
            PropertyDescriptor sourcePd;
            Method writeMethod = targetPd.getWriteMethod();
            if (writeMethod == null || (sourcePd = MyBeanUtil.getPropertyDescriptor(source.getClass(), (String)targetPd.getName())) == null || sourcePd.getReadMethod() == null) continue;
            try {
                Object value;
                Method readMethod = sourcePd.getReadMethod();
                if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
                    readMethod.setAccessible(true);
                }
                if ((value = readMethod.invoke(source, new Object[0])) == null) continue;
                if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
                    writeMethod.setAccessible(true);
                }
                writeMethod.invoke(target, value);
            }
            catch (Throwable ex) {
                throw new FatalBeanException("Could not copy properties from source to target field name mismatch:" + targetPd.getName(), ex);
            }
        }
    }

    public static void copyPropertiesForMap(Map<String, Object> map, Object target) {
        Assert.notNull(map, (String)"map must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Object pojo = MyBeanUtil.mapToPojo(map, target.getClass());
        MyBeanUtil.copyProperties(pojo, (Object)target);
    }

    public static Map<String, Object> pojoToMap(Object pojo) {
        if (pojo == null) {
            return Collections.emptyMap();
        }
        String json = JSON.toJSONString((Object)pojo);
        return JSON.parseObject((String)json);
    }

    public static Map<String, Object> createUpdateMap(Object pojo) {
        return MyBeanUtil.doCreateUpdateMap(pojo, false);
    }

    public static Map<String, Object> createUpdateMapIgnoreNull(Object pojo) {
        return MyBeanUtil.doCreateUpdateMap(pojo, true);
    }

    public static Map<String, Object> doCreateUpdateMap(Object pojo, boolean ignoreNull) {
        Class<?> clazz = pojo.getClass();
        String key = clazz.getName();
        List<Method> methods = objGetMethods.get(key);
        if (methods == null) {
            Method[] clazzMethods;
            methods = new ArrayList<Method>();
            for (Method method : clazzMethods = clazz.getMethods()) {
                if (!MyBeanUtil.isGetMethod(method)) continue;
                methods.add(method);
            }
            objGetMethods.put(key, methods);
        }
        if (CollectionUtils.isEmpty(methods)) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> ret = new HashMap<String, Object>(8);
        try {
            for (Method method : methods) {
                Object value = method.invoke(pojo, new Object[0]);
                if (value == null && ignoreNull) continue;
                String columnName = method.getName().substring(3);
                ret.put(FieldUtil.camelToUnderline(columnName), value);
            }
        }
        catch (Exception e) {
            throw new QueryException(e);
        }
        return ret;
    }

    public static boolean isGetMethod(Method method) {
        if (method.getReturnType() == Void.TYPE) {
            return false;
        }
        String methodName = method.getName();
        return !GETCLASS_NAME.equals(methodName) && methodName.startsWith(PREFIX_GET);
    }

    public static <T> T mapToPojo(Map<String, Object> map, Class<T> pojoClass) {
        return (T)new JSONObject(map).toJavaObject(pojoClass);
    }

    public static <T> List<T> mapListToObjList(List<Map<String, Object>> list, Class<T> pojoClass) {
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<T> retList = new ArrayList<T>(list.size());
        for (Map<String, Object> map : list) {
            retList.add(MyBeanUtil.mapToPojo(map, pojoClass));
        }
        return retList;
    }
}

