/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.function.BiConsumer;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.J2Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class J2CacheConfig {
    private static final Logger log = LoggerFactory.getLogger(J2CacheConfig.class);
    private Properties properties;
    private String broadcast;
    private String l1CacheName;
    private String l2CacheName;
    private String serialization;
    private boolean syncTtlToRedis;
    private boolean defaultCacheNullObject;
    private Properties broadcastProperties = new Properties();
    private Properties l1CacheProperties = new Properties();
    private Properties l2CacheProperties = new Properties();

    public static final J2CacheConfig initFromConfig(String configResource) throws IOException {
        J2CacheConfig config = new J2CacheConfig();
        try (InputStream stream = J2CacheConfig.getConfigStream(configResource);){
            config.properties = new Properties();
            config.properties.load(stream);
            config.serialization = config.properties.getProperty("j2cache.serialization");
            config.broadcast = config.properties.getProperty("j2cache.broadcast");
            config.l1CacheName = config.properties.getProperty("j2cache.L1.provider_class");
            config.l2CacheName = config.properties.getProperty("j2cache.L2.provider_class");
            config.syncTtlToRedis = !"false".equalsIgnoreCase(config.properties.getProperty("j2cache.sync_ttl_to_redis"));
            config.defaultCacheNullObject = "true".equalsIgnoreCase(config.properties.getProperty("j2cache.default_cache_null_object"));
            String l2_config_section = config.properties.getProperty("j2cache.L2.config_section");
            if (l2_config_section == null || l2_config_section.trim().equals("")) {
                l2_config_section = config.l2CacheName;
            }
            String l2_section = l2_config_section;
            config.properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
                String key = (String)k;
                if (key.startsWith(j2CacheConfig.broadcast + ".")) {
                    j2CacheConfig.broadcastProperties.setProperty(key.substring((j2CacheConfig.broadcast + ".").length()), (String)v);
                }
                if (key.startsWith(j2CacheConfig.l1CacheName + ".")) {
                    j2CacheConfig.l1CacheProperties.setProperty(key.substring((j2CacheConfig.l1CacheName + ".").length()), (String)v);
                }
                if (key.startsWith(l2_section + ".")) {
                    j2CacheConfig.l2CacheProperties.setProperty(key.substring((l2_section + ".").length()), (String)v);
                }
            }));
        }
        return config;
    }

    private static InputStream getConfigStream(String resource) {
        log.info("Load J2Cache Config File : [{}].", (Object)resource);
        InputStream configStream = J2Cache.class.getResourceAsStream(resource);
        if (configStream == null) {
            configStream = J2Cache.class.getClassLoader().getParent().getResourceAsStream(resource);
        }
        if (configStream == null) {
            throw new CacheException("Cannot find " + resource + " !!!");
        }
        return configStream;
    }

    public void dump(PrintStream writer) {
        writer.printf("j2cache.serialization = %s%n", this.serialization);
        writer.printf("[%s]%n", this.broadcast);
        this.broadcastProperties.list(writer);
        writer.printf("[%s]%n", this.l1CacheName);
        this.l1CacheProperties.list(writer);
        writer.printf("[%s]%n", this.l2CacheName);
        this.l2CacheProperties.list(writer);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public String getBroadcast() {
        return this.broadcast;
    }

    public void setBroadcast(String broadcast) {
        this.broadcast = broadcast;
    }

    public boolean isSyncTtlToRedis() {
        return this.syncTtlToRedis;
    }

    public void setSyncTtlToRedis(boolean syncTtlToRedis) {
        this.syncTtlToRedis = syncTtlToRedis;
    }

    public boolean isDefaultCacheNullObject() {
        return this.defaultCacheNullObject;
    }

    public void setDefaultCacheNullObject(boolean defaultCacheNullObject) {
        this.defaultCacheNullObject = defaultCacheNullObject;
    }

    public String getL1CacheName() {
        return this.l1CacheName;
    }

    public void setL1CacheName(String provider1) {
        this.l1CacheName = provider1;
    }

    public String getL2CacheName() {
        return this.l2CacheName;
    }

    public void setL2CacheName(String provider2) {
        this.l2CacheName = provider2;
    }

    public String getSerialization() {
        return this.serialization;
    }

    public void setSerialization(String serialization) {
        this.serialization = serialization;
    }

    public Properties getBroadcastProperties() {
        return this.broadcastProperties;
    }

    public void setBroadcastProperties(Properties broadcastProperties) {
        this.broadcastProperties = broadcastProperties;
    }

    public Properties getL1CacheProperties() {
        return this.l1CacheProperties;
    }

    public void setL1CacheProperties(Properties l1CacheProperties) {
        this.l1CacheProperties = l1CacheProperties;
    }

    public Properties getL2CacheProperties() {
        return this.l2CacheProperties;
    }

    public void setL2CacheProperties(Properties l2CacheProperties) {
        this.l2CacheProperties = l2CacheProperties;
    }
}

