/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.caffeine;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.RemovalCause;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.caffeine.CaffeineCache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaffeineProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(CaffeineProvider.class);
    private static final String PREFIX_REGION = "region.";
    private static final String DEFAULT_REGION = "default";
    private ConcurrentHashMap<String, CaffeineCache> caches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CacheConfig> cacheConfigs = new ConcurrentHashMap();

    @Override
    public String name() {
        return "caffeine";
    }

    @Override
    public int level() {
        return 1;
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        ArrayList<CacheChannel.Region> regions = new ArrayList<CacheChannel.Region>();
        this.caches.forEach((k, c) -> regions.add(new CacheChannel.Region((String)k, c.size(), c.ttl())));
        return regions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        CaffeineCache cache = this.caches.get(region);
        if (cache != null) {
            return cache;
        }
        Class<CaffeineProvider> clazz = CaffeineProvider.class;
        synchronized (CaffeineProvider.class) {
            cache = this.caches.get(region);
            if (cache != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return cache;
            }
            CacheConfig config = this.cacheConfigs.get(region);
            if (config == null) {
                config = this.cacheConfigs.get(DEFAULT_REGION);
                if (config == null) {
                    throw new CacheException(String.format("Undefined caffeine cache region name = %s", region));
                }
                log.info(String.format("Caffeine cache [%s] not defined, using default.", region));
            }
            cache = this.buildCache(region, config.size, config.expire, listener);
            this.caches.put(region, cache);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return cache;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        CacheConfig config = this.cacheConfigs.get(region);
        if (config != null) {
            if (config.expire != timeToLiveInSeconds) throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, config.expire, timeToLiveInSeconds));
            return this.buildCache(region, listener);
        }
        CaffeineCache cache = this.caches.get(region);
        if (cache != null) {
            if (cache.ttl() == timeToLiveInSeconds) return cache;
            throw new IllegalArgumentException(String.format("Region [%s] TTL %d not match with %d", region, cache.ttl(), timeToLiveInSeconds));
        }
        Class<CaffeineProvider> clazz = CaffeineProvider.class;
        synchronized (CaffeineProvider.class) {
            cache = this.caches.get(region);
            if (cache != null) return cache;
            config = this.cacheConfigs.get(DEFAULT_REGION);
            if (config == null) {
                throw new CacheException(String.format("Undefined caffeine cache region name = %s", region));
            }
            cache = this.buildCache(region, config.size, timeToLiveInSeconds, listener);
            this.caches.put(region, cache);
            log.info(String.format("Started caffeine region [%s] with TTL: %d", region, timeToLiveInSeconds));
            // ** MonitorExit[var7_6] (shouldn't be in output)
            return cache;
        }
    }

    private CaffeineCache buildCache(String region, long size, long expire, CacheExpiredListener listener) {
        com.github.benmanes.caffeine.cache.Cache loadingCache = Caffeine.newBuilder().maximumSize(size).expireAfterWrite(expire, TimeUnit.SECONDS).removalListener((k, v, cause) -> {
            if (cause != RemovalCause.EXPLICIT && cause != RemovalCause.REPLACED) {
                listener.notifyElementExpired(region, (String)k);
            }
        }).build();
        return new CaffeineCache((com.github.benmanes.caffeine.cache.Cache<String, Object>)loadingCache, size, expire);
    }

    @Override
    public void start(Properties props) {
        for (String region : props.stringPropertyNames()) {
            if (!region.startsWith(PREFIX_REGION)) continue;
            String s_config = props.getProperty(region).trim();
            region = region.substring(PREFIX_REGION.length());
            this.saveCacheConfig(region, s_config);
        }
        String propertiesFile = props.getProperty("properties");
        if (propertiesFile != null && propertiesFile.trim().length() > 0) {
            try (InputStream stream = this.getClass().getResourceAsStream(propertiesFile);){
                Properties regionsProps = new Properties();
                regionsProps.load(stream);
                for (String region : regionsProps.stringPropertyNames()) {
                    String s_config = regionsProps.getProperty(region).trim();
                    this.saveCacheConfig(region, s_config);
                }
            }
            catch (IOException e) {
                log.error("Failed to load caffeine regions define " + propertiesFile, (Throwable)e);
            }
        }
    }

    private void saveCacheConfig(String region, String region_config) {
        CacheConfig cfg = CacheConfig.parse(region_config);
        if (cfg == null) {
            log.warn(String.format("Illegal caffeine cache config [%s=%s]", region, region_config));
        } else {
            this.cacheConfigs.put(region, cfg);
        }
    }

    @Override
    public void stop() {
    }

    private static class CacheConfig {
        private long size = 0L;
        private long expire = 0L;

        private CacheConfig() {
        }

        public static CacheConfig parse(String cfg) {
            CacheConfig cacheConfig = null;
            String[] cfgs = cfg.split(",");
            if (cfgs.length == 1) {
                cacheConfig = new CacheConfig();
                String sSize = cfgs[0].trim();
                cacheConfig.size = Long.parseLong(sSize);
            } else if (cfgs.length == 2) {
                cacheConfig = new CacheConfig();
                String sSize = cfgs[0].trim();
                String sExpire = cfgs[1].trim();
                cacheConfig.size = Long.parseLong(sSize);
                char unit = Character.toLowerCase(sExpire.charAt(sExpire.length() - 1));
                cacheConfig.expire = Long.parseLong(sExpire.substring(0, sExpire.length() - 1));
                switch (unit) {
                    case 's': {
                        break;
                    }
                    case 'm': {
                        cacheConfig.expire *= 60L;
                        break;
                    }
                    case 'h': {
                        cacheConfig.expire *= 3600L;
                        break;
                    }
                    case 'd': {
                        cacheConfig.expire *= 86400L;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown expire unit:" + unit);
                    }
                }
            }
            return cacheConfig;
        }

        public String toString() {
            return String.format("[SIZE:%d,EXPIRE:%d]", this.size, this.expire);
        }
    }
}

