/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.redis.RedisClient;
import net.oschina.j2cache.redis.RedisGenericCache;
import net.oschina.j2cache.redis.RedisHashCache;
import net.oschina.j2cache.redis.RedisUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.JedisPoolConfig;

public class RedisCacheProvider
implements CacheProvider {
    private static final Logger log = LoggerFactory.getLogger(RedisCacheProvider.class);
    private RedisClient redisClient;
    private String namespace;
    private String storage;
    private static final ConcurrentHashMap<String, Level2Cache> regions = new ConcurrentHashMap();

    @Override
    public String name() {
        return "redis";
    }

    @Override
    public int level() {
        return 2;
    }

    @Override
    public void start(Properties props) {
        this.namespace = props.getProperty("namespace");
        this.storage = props.getProperty("storage");
        JedisPoolConfig poolConfig = RedisUtils.newPoolConfig(props, null);
        String hosts = props.getProperty("hosts", "127.0.0.1:6379");
        String mode = props.getProperty("mode", "single");
        String clusterName = props.getProperty("cluster_name");
        String password = props.getProperty("password");
        int database = Integer.parseInt(props.getProperty("database", "0"));
        long ct = System.currentTimeMillis();
        this.redisClient = new RedisClient.Builder().mode(mode).hosts(hosts).password(password).cluster(clusterName).database(database).poolConfig(poolConfig).newClient();
        log.info(String.format("Redis client starts with mode(%s),db(%d),storage(%s),namespace(%s),time(%dms)", mode, database, this.storage, this.namespace, System.currentTimeMillis() - ct));
    }

    @Override
    public void stop() {
        regions.clear();
        try {
            this.redisClient.close();
        }
        catch (IOException e) {
            log.warn("Failed to close redis connection.", (Throwable)e);
        }
    }

    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        return regions.computeIfAbsent(region, v -> "hash".equalsIgnoreCase(this.storage) ? new RedisHashCache(this.namespace, region, this.redisClient) : new RedisGenericCache(this.namespace, region, this.redisClient));
    }

    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        return this.buildCache(region, listener);
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        return Collections.emptyList();
    }

    public RedisClient getRedisClient() {
        return this.redisClient;
    }
}

