/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.lettuce;

import io.lettuce.core.AbstractRedisClient;
import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.codec.RedisCodec;
import io.lettuce.core.pubsub.RedisPubSubAdapter;
import io.lettuce.core.pubsub.RedisPubSubListener;
import io.lettuce.core.pubsub.StatefulRedisPubSubConnection;
import io.lettuce.core.pubsub.api.async.RedisPubSubAsyncCommands;
import io.lettuce.core.pubsub.api.sync.RedisPubSubCommands;
import io.lettuce.core.support.ConnectionPoolSupport;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import net.oschina.j2cache.Cache;
import net.oschina.j2cache.CacheChannel;
import net.oschina.j2cache.CacheExpiredListener;
import net.oschina.j2cache.CacheProvider;
import net.oschina.j2cache.CacheProviderHolder;
import net.oschina.j2cache.Command;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.cluster.ClusterPolicy;
import net.oschina.j2cache.lettuce.LettuceByteCodec;
import net.oschina.j2cache.lettuce.LettuceGenericCache;
import net.oschina.j2cache.lettuce.LettuceHashCache;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;

public class LettuceCacheProvider
extends RedisPubSubAdapter<String, String>
implements CacheProvider,
ClusterPolicy {
    private int LOCAL_COMMAND_ID = Command.genRandomSrc();
    private static final LettuceByteCodec codec = new LettuceByteCodec();
    private static AbstractRedisClient redisClient;
    GenericObjectPool<StatefulConnection<String, byte[]>> pool;
    private StatefulRedisPubSubConnection<String, String> pubsub_subscriber;
    private String storage;
    private CacheProviderHolder holder;
    private String channel;
    private String namespace;
    private final ConcurrentHashMap<String, Level2Cache> regions = new ConcurrentHashMap();

    @Override
    public String name() {
        return "lettuce";
    }

    @Override
    public int level() {
        return 2;
    }

    @Override
    public boolean isLocalCommand(Command cmd) {
        return cmd.getSrc() == this.LOCAL_COMMAND_ID;
    }

    @Override
    public void start(Properties props) {
        this.namespace = props.getProperty("namespace");
        this.storage = props.getProperty("storage", "hash");
        this.channel = props.getProperty("channel", "j2cache");
        String scheme = props.getProperty("scheme", "redis");
        String hosts = props.getProperty("hosts", "127.0.0.1:6379");
        String password = props.getProperty("password");
        int database = Integer.parseInt(props.getProperty("database", "0"));
        String sentinelMasterId = props.getProperty("sentinelMasterId");
        boolean isCluster = false;
        if ("redis-cluster".equalsIgnoreCase(scheme)) {
            scheme = "redis";
            isCluster = true;
        }
        String redis_url = String.format("%s://%s@%s/%d#%s", scheme, password, hosts, database, sentinelMasterId);
        redisClient = isCluster ? RedisClusterClient.create((String)redis_url) : RedisClient.create((String)redis_url);
        try {
            int timeout = Integer.parseInt(props.getProperty("timeout", "10000"));
            redisClient.setDefaultTimeout(Duration.ofMillis(timeout));
        }
        catch (Exception e) {
            log.warn("Failed to set default timeout, using default 10000 milliseconds.", (Throwable)e);
        }
        GenericObjectPoolConfig poolConfig = new GenericObjectPoolConfig();
        poolConfig.setMaxTotal(Integer.parseInt(props.getProperty("maxTotal", "100")));
        poolConfig.setMaxIdle(Integer.parseInt(props.getProperty("maxIdle", "10")));
        poolConfig.setMinIdle(Integer.parseInt(props.getProperty("minIdle", "10")));
        this.pool = ConnectionPoolSupport.createGenericObjectPool(() -> {
            if (redisClient instanceof RedisClient) {
                return ((RedisClient)redisClient).connect((RedisCodec)codec);
            }
            if (redisClient instanceof RedisClusterClient) {
                return ((RedisClusterClient)redisClient).connect((RedisCodec)codec);
            }
            return null;
        }, (GenericObjectPoolConfig)poolConfig);
    }

    @Override
    public void stop() {
        this.pool.close();
        this.regions.clear();
        redisClient.shutdown();
    }

    @Override
    public Cache buildCache(String region, CacheExpiredListener listener) {
        return this.regions.computeIfAbsent(this.namespace + ":" + region, v -> "hash".equalsIgnoreCase(this.storage) ? new LettuceHashCache(this.namespace, region, this.pool) : new LettuceGenericCache(this.namespace, region, this.pool));
    }

    @Override
    public Cache buildCache(String region, long timeToLiveInSeconds, CacheExpiredListener listener) {
        return this.buildCache(region, listener);
    }

    @Override
    public Collection<CacheChannel.Region> regions() {
        return Collections.emptyList();
    }

    @Override
    public void evict(String region, String ... keys) {
        this.holder.getLevel1Cache(region).evict(keys);
    }

    @Override
    public void clear(String region) {
        this.holder.getLevel1Cache(region).clear();
    }

    private StatefulRedisPubSubConnection pubsub() {
        if (redisClient instanceof RedisClient) {
            return ((RedisClient)redisClient).connectPubSub();
        }
        if (redisClient instanceof RedisClusterClient) {
            return ((RedisClusterClient)redisClient).connectPubSub();
        }
        return null;
    }

    @Override
    public void connect(Properties props, CacheProviderHolder holder) {
        long ct = System.currentTimeMillis();
        this.holder = holder;
        this.channel = props.getProperty("channel", "j2cache");
        this.publish(Command.join());
        this.pubsub_subscriber = this.pubsub();
        this.pubsub_subscriber.addListener((RedisPubSubListener)this);
        RedisPubSubAsyncCommands async = this.pubsub_subscriber.async();
        async.subscribe((Object[])new String[]{this.channel});
        log.info("Connected to redis channel:{}, time {}ms.", (Object)this.channel, (Object)(System.currentTimeMillis() - ct));
    }

    public void message(String channel, String message) {
        Command cmd = Command.parse(message);
        this.handleCommand(cmd);
    }

    @Override
    public void publish(Command cmd) {
        cmd.setSrc(this.LOCAL_COMMAND_ID);
        try (StatefulRedisPubSubConnection connection = this.pubsub();){
            RedisPubSubCommands sync = connection.sync();
            sync.publish((Object)this.channel, (Object)cmd.json());
        }
    }

    @Override
    public void disconnect() {
        try {
            this.publish(Command.quit());
            super.unsubscribed((Object)this.channel, 1L);
        }
        finally {
            this.pubsub_subscriber.close();
        }
    }
}

