/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache;

import net.oschina.j2cache.NullObject;

public class CacheObject {
    public static final byte LEVEL_1 = 1;
    public static final byte LEVEL_2 = 2;
    public static final byte LEVEL_OUTER = 3;
    private String region;
    private String key;
    private Object value;
    private byte level;

    public CacheObject(String region, String key, byte level) {
        this(region, key, level, null);
    }

    public CacheObject(String region, String key, byte level, Object value) {
        this.region = region;
        this.key = key;
        this.level = level;
        this.value = value;
    }

    public void setLevel(byte level) {
        this.level = level;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getRegion() {
        return this.region;
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        if (this.value == null || this.value.getClass().equals(NullObject.class) || this.value.getClass().equals(Object.class)) {
            return null;
        }
        return this.value;
    }

    public Object rawValue() {
        return this.value;
    }

    public byte getLevel() {
        return this.level;
    }

    public String asString() {
        return String.valueOf(this.value);
    }

    public int asInt() {
        return this.value instanceof String ? Integer.parseInt((String)this.value) : (Integer)this.value;
    }

    public int asInt(int defValue) {
        try {
            return Integer.parseInt(this.asString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public double asDouble() {
        return this.value instanceof String ? Double.parseDouble((String)this.value) : (Double)this.value;
    }

    public double asDouble(double defValue) {
        try {
            return Double.parseDouble(this.asString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public long asLong() {
        return this.value instanceof String ? Long.parseLong((String)this.value) : (Long)this.value;
    }

    public long asLong(long defValue) {
        try {
            return Long.parseLong(this.asString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public float asFloat() {
        return this.value instanceof String ? Float.parseFloat((String)this.value) : ((Float)this.value).floatValue();
    }

    public float asFloat(float defValue) {
        try {
            return Float.parseFloat(this.asString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    public String toString() {
        return String.format("[%s,%s,L%d]=>%s", this.region, this.key, this.level, this.getValue());
    }
}

