/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.lettuce;

import io.lettuce.core.api.StatefulConnection;
import io.lettuce.core.api.sync.RedisHashCommands;
import io.lettuce.core.api.sync.RedisKeyCommands;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.lettuce.LettuceCache;
import org.apache.commons.pool2.impl.GenericObjectPool;

public class LettuceHashCache
extends LettuceCache {
    public LettuceHashCache(String namespace, String region, GenericObjectPool<StatefulConnection<String, byte[]>> pool) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.pool = pool;
        this.namespace = namespace;
        this.region = this.getRegionName(region);
    }

    private String getRegionName(String region) {
        if (this.namespace != null && !this.namespace.trim().isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    @Override
    public byte[] getBytes(String key) {
        try (StatefulConnection connection = super.connect();){
            RedisHashCommands cmd = (RedisHashCommands)super.sync(connection);
            byte[] byArray = (byte[])cmd.hget((Object)this.region, (Object)key);
            return byArray;
        }
    }

    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try (StatefulConnection connection = super.connect();){
            RedisHashCommands cmd = (RedisHashCommands)super.sync(connection);
            List<byte[]> list = cmd.hmget((Object)this.region, (Object[])((String[])keys.stream().toArray(String[]::new))).stream().map(kv -> kv.hasValue() ? (byte[])kv.getValue() : null).collect(Collectors.toList());
            return list;
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        try (StatefulConnection connection = super.connect();){
            RedisHashCommands cmd = (RedisHashCommands)super.sync(connection);
            cmd.hset((Object)this.region, (Object)key, (Object)bytes);
        }
    }

    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        try (StatefulConnection connection = super.connect();){
            RedisHashCommands cmd = (RedisHashCommands)super.sync(connection);
            cmd.hmset((Object)this.region, bytes);
        }
    }

    @Override
    public Collection<String> keys() {
        try (StatefulConnection connection = super.connect();){
            RedisHashCommands cmd = (RedisHashCommands)super.sync(connection);
            List list = cmd.hkeys((Object)this.region);
            return list;
        }
    }

    @Override
    public void evict(String ... keys) {
        try (StatefulConnection connection = super.connect();){
            RedisHashCommands cmd = (RedisHashCommands)super.sync(connection);
            cmd.hdel((Object)this.region, (Object[])keys);
        }
    }

    @Override
    public void clear() {
        try (StatefulConnection connection = super.connect();){
            RedisKeyCommands cmd = (RedisKeyCommands)super.sync(connection);
            cmd.del((Object[])new String[]{this.region});
        }
    }
}

