/*
 * Decompiled with CFR 0.152.
 */
package net.oschina.j2cache.redis;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.oschina.j2cache.CacheException;
import net.oschina.j2cache.Level2Cache;
import net.oschina.j2cache.redis.RedisClient;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BinaryJedisCommands;
import redis.clients.jedis.MultiKeyBinaryCommands;
import redis.clients.jedis.MultiKeyCommands;
import redis.clients.jedis.ScanParams;
import redis.clients.jedis.ScanResult;

public class RedisGenericCache
implements Level2Cache {
    private static final Logger log = LoggerFactory.getLogger(RedisGenericCache.class);
    private String namespace;
    private String region;
    private RedisClient client;
    private int scanCount;

    public RedisGenericCache(String namespace, String region, RedisClient client, int scanCount) {
        if (region == null || region.isEmpty()) {
            region = "_";
        }
        this.client = client;
        this.namespace = namespace;
        this.region = this._regionName(region);
        this.scanCount = scanCount;
    }

    @Override
    public boolean supportTTL() {
        return true;
    }

    private String _regionName(String region) {
        if (this.namespace != null && !this.namespace.trim().isEmpty()) {
            region = this.namespace + ":" + region;
        }
        return region;
    }

    private byte[] _key(String key) {
        try {
            return (this.region + ":" + key).getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            return (this.region + ":" + key).getBytes();
        }
    }

    @Override
    public byte[] getBytes(String key) {
        try {
            byte[] byArray = this.client.get().get(this._key(key));
            return byArray;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<byte[]> getBytes(Collection<String> keys) {
        try {
            BinaryJedisCommands cmd = this.client.get();
            if (cmd instanceof MultiKeyBinaryCommands) {
                byte[][] bytes = (byte[][])keys.stream().map(k -> this._key((String)k)).toArray(x$0 -> new byte[x$0][]);
                List list = ((MultiKeyBinaryCommands)cmd).mget(bytes);
                return list;
            }
            List<byte[]> list = keys.stream().map(k -> this.getBytes((String)k)).collect(Collectors.toList());
            return list;
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public void setBytes(String key, byte[] bytes) {
        try {
            this.client.get().set(this._key(key), bytes);
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(Map<String, byte[]> bytes) {
        try {
            BinaryJedisCommands cmd = this.client.get();
            if (cmd instanceof MultiKeyBinaryCommands) {
                byte[][] data = new byte[bytes.size() * 2][];
                int idx = 0;
                for (String key : bytes.keySet()) {
                    data[idx++] = this._key(key);
                    data[idx++] = bytes.get(key);
                }
                ((MultiKeyBinaryCommands)cmd).mset((byte[][])data);
            } else {
                bytes.forEach((k, v) -> this.setBytes((String)k, (byte[])v));
            }
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(String key, byte[] bytes, long timeToLiveInSeconds) {
        if (timeToLiveInSeconds <= 0L) {
            log.debug(String.format("Invalid timeToLiveInSeconds value : %d , skipped it.", timeToLiveInSeconds));
            this.setBytes(key, bytes);
        } else {
            try {
                this.client.get().setex(this._key(key), (int)timeToLiveInSeconds, bytes);
            }
            finally {
                this.client.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(Map<String, byte[]> bytes, long timeToLiveInSeconds) {
        try {
            if (timeToLiveInSeconds <= 0L) {
                log.debug(String.format("Invalid timeToLiveInSeconds value : %d , skipped it.", timeToLiveInSeconds));
                this.setBytes(bytes);
            } else {
                bytes.forEach((k, v) -> this.setBytes((String)k, (byte[])v, timeToLiveInSeconds));
            }
        }
        finally {
            this.client.release();
        }
    }

    @Override
    public boolean exists(String key) {
        try {
            boolean bl = this.client.get().exists(this._key(key));
            return bl;
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> keys() {
        try {
            BinaryJedisCommands cmd = this.client.get();
            if (cmd instanceof MultiKeyCommands) {
                Collection<String> keys = this.keys(cmd);
                Collection collection = keys.stream().map(k -> k.substring(this.region.length() + 1)).collect(Collectors.toList());
                return collection;
            }
        }
        finally {
            this.client.release();
        }
        throw new CacheException("keys() not implemented in Redis Generic Mode");
    }

    private Collection<String> keys(BinaryJedisCommands cmd) {
        ArrayList<String> keys = new ArrayList<String>();
        String cursor = "0";
        ScanParams scanParams = new ScanParams();
        scanParams.match(this.region + ":*");
        scanParams.count(Integer.valueOf(this.scanCount));
        ScanResult scan = ((MultiKeyCommands)cmd).scan(cursor, scanParams);
        while (null != scan.getStringCursor()) {
            keys.addAll(scan.getResult());
            if (StringUtils.equals((CharSequence)cursor, (CharSequence)scan.getStringCursor())) break;
            scan = ((MultiKeyCommands)cmd).scan(scan.getStringCursor(), scanParams);
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evict(String ... keys) {
        try {
            BinaryJedisCommands cmd = this.client.get();
            if (cmd instanceof BinaryJedis) {
                byte[][] bytes = (byte[][])Arrays.stream(keys).map(k -> this._key((String)k)).toArray(x$0 -> new byte[x$0][]);
                ((BinaryJedis)cmd).del(bytes);
            } else {
                for (String key : keys) {
                    cmd.del(this._key(key));
                }
            }
        }
        finally {
            this.client.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        block5: {
            try {
                BinaryJedisCommands cmd = this.client.get();
                if (cmd instanceof MultiKeyCommands) {
                    Collection<String> keysCollection = this.keys(cmd);
                    String[] keys = (String[])keysCollection.stream().toArray(String[]::new);
                    if (keys != null && keys.length > 0) {
                        ((MultiKeyCommands)cmd).del(keys);
                    }
                    break block5;
                }
                throw new CacheException("clear() not implemented in Redis Generic Mode");
            }
            finally {
                this.client.release();
            }
        }
    }
}

