/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.xml;

import java.util.Map;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import net.revelc.code.formatter.xml.lib.FormattingPreferences;
import net.revelc.code.formatter.xml.lib.XmlDocumentFormatter;

public class XMLFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private XmlDocumentFormatter formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        FormattingPreferences prefs = new FormattingPreferences();
        String maxLineLength = options.get("maxLineLength");
        String wrapLongLines = options.get("wrapLongLines");
        String tabInsteadOfSpaces = options.get("tabInsteadOfSpaces");
        String tabWidth = options.get("tabWidth");
        String splitMultiAttrs = options.get("splitMultiAttrs");
        prefs.setMaxLineLength(maxLineLength != null ? Integer.valueOf(maxLineLength) : null);
        prefs.setWrapLongLines(wrapLongLines != null ? Boolean.valueOf(wrapLongLines) : null);
        prefs.setTabInsteadOfSpaces(tabInsteadOfSpaces != null ? Boolean.valueOf(tabInsteadOfSpaces) : null);
        prefs.setTabWidth(tabWidth != null ? Integer.valueOf(tabWidth) : null);
        prefs.setSplitMultiAttrs(splitMultiAttrs != null ? Boolean.valueOf(splitMultiAttrs) : null);
        this.formatter = new XmlDocumentFormatter(options.getOrDefault("lineending", System.lineSeparator()), prefs);
    }

    @Override
    protected String doFormat(String code, LineEnding ending) {
        String formattedCode = this.formatter.format(code);
        if (code.equals(formattedCode)) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

