/*
 * Decompiled with CFR 0.152.
 */
package net.sf.clirr.core.internal.bcel;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.sf.clirr.core.CheckerException;
import net.sf.clirr.core.ClassFilter;
import net.sf.clirr.core.ClassSelector;
import net.sf.clirr.core.internal.ExceptionUtil;
import net.sf.clirr.core.internal.bcel.BcelJavaType;
import net.sf.clirr.core.spi.JavaType;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.util.ClassLoaderRepository;
import org.apache.bcel.util.Repository;

public final class BcelTypeArrayBuilder {
    private BcelTypeArrayBuilder() {
    }

    public static JavaType[] createClassSet(File[] jarFiles, ClassLoader thirdPartyClasses, ClassFilter classSelector) throws CheckerException {
        if (classSelector == null) {
            classSelector = new ClassSelector(ClassSelector.MODE_UNLESS);
        }
        ClassLoader classLoader = BcelTypeArrayBuilder.createClassLoader(jarFiles, thirdPartyClasses);
        ClassLoaderRepository repository = new ClassLoaderRepository(classLoader);
        ArrayList<BcelJavaType> selected = new ArrayList<BcelJavaType>();
        for (int i = 0; i < jarFiles.length; ++i) {
            File jarFile = jarFiles[i];
            ZipFile zip = null;
            try {
                zip = new ZipFile(jarFile, 1);
            }
            catch (IOException ex) {
                throw new CheckerException("Cannot open " + jarFile + " for reading", ex);
            }
            Enumeration<? extends ZipEntry> enumEntries = zip.entries();
            while (enumEntries.hasMoreElements()) {
                JavaClass clazz;
                ZipEntry zipEntry = enumEntries.nextElement();
                if (zipEntry.isDirectory() || !zipEntry.getName().endsWith(".class") || !classSelector.isSelected(clazz = BcelTypeArrayBuilder.extractClass(zipEntry, zip, (Repository)repository))) continue;
                selected.add(new BcelJavaType(clazz));
                repository.storeClass(clazz);
            }
        }
        JavaType[] ret = new JavaType[selected.size()];
        selected.toArray(ret);
        return ret;
    }

    private static ClassLoader createClassLoader(File[] jarFiles, ClassLoader thirdPartyClasses) {
        URL[] jarUrls = new URL[jarFiles.length];
        for (int i = 0; i < jarFiles.length; ++i) {
            File jarFile = jarFiles[i];
            try {
                URL url;
                jarUrls[i] = url = jarFile.toURL();
                continue;
            }
            catch (MalformedURLException ex) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot create classloader with jar file " + jarFile);
                ExceptionUtil.initCause(illegalArgumentException, ex);
                throw illegalArgumentException;
            }
        }
        URLClassLoader jarsLoader = new URLClassLoader(jarUrls, thirdPartyClasses);
        return jarsLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JavaClass extractClass(ZipEntry zipEntry, ZipFile zip, Repository repository) throws CheckerException {
        JavaClass javaClass;
        String name = zipEntry.getName();
        InputStream is = null;
        try {
            try {
                is = zip.getInputStream(zipEntry);
                ClassParser parser = new ClassParser(is, name);
                JavaClass clazz = parser.parse();
                clazz.setRepository(repository);
                javaClass = clazz;
                Object var9_9 = null;
                if (is == null) return javaClass;
            }
            catch (IOException ex) {
                throw new CheckerException("Cannot read " + zipEntry.getName() + " from " + zip.getName(), ex);
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException ex2) {
                throw new CheckerException("Cannot close " + zip.getName(), ex2);
            }
        }
        try {}
        catch (IOException ex2) {
            throw new CheckerException("Cannot close " + zip.getName(), ex2);
        }
        is.close();
        return javaClass;
    }
}

