/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ezmorph.object;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import net.sf.ezmorph.MorphException;
import net.sf.ezmorph.object.AbstractObjectMorpher;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DateMorpher
extends AbstractObjectMorpher {
    private Date defaultValue;
    private String[] formats;
    private boolean lenient;
    private Locale locale;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;

    public DateMorpher(String[] formats) {
        this(formats, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, Date defaultValue) {
        this(formats, defaultValue, Locale.getDefault(), false);
    }

    public DateMorpher(String[] formats, Date defaultValue, Locale locale, boolean lenient) {
        super(true);
        if (formats == null || formats.length == 0) {
            throw new IllegalArgumentException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
        this.setDefaultValue(defaultValue);
    }

    public DateMorpher(String[] formats, Locale locale, boolean lenient) {
        if (formats == null || formats.length == 0) {
            throw new IllegalArgumentException("invalid array of formats");
        }
        this.formats = formats;
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.lenient = lenient;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateMorpher)) {
            return false;
        }
        DateMorpher other = (DateMorpher)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object[])this.formats, (Object[])other.formats);
        builder.append((Object)this.locale, (Object)other.locale);
        builder.append(this.lenient, other.lenient);
        if (this.isUseDefault() && other.isUseDefault()) {
            builder.append((Object)this.getDefaultValue(), (Object)other.getDefaultValue());
            return builder.isEquals();
        }
        if (!this.isUseDefault() && !other.isUseDefault()) {
            return builder.isEquals();
        }
        return false;
    }

    public Date getDefaultValue() {
        return (Date)this.defaultValue.clone();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object[])this.formats);
        builder.append((Object)this.locale);
        builder.append(this.lenient);
        if (this.isUseDefault()) {
            builder.append((Object)this.getDefaultValue());
        }
        return builder.toHashCode();
    }

    public Object morph(Object value) {
        if (value == null) {
            return null;
        }
        if ((class$java$util$Date == null ? (class$java$util$Date = DateMorpher.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(value.getClass())) {
            return (Date)value;
        }
        if (!this.supports(value.getClass())) {
            throw new MorphException(value.getClass() + " is not supported");
        }
        String strValue = (String)value;
        SimpleDateFormat dateParser = null;
        for (int i = 0; i < this.formats.length; ++i) {
            if (dateParser == null) {
                dateParser = new SimpleDateFormat(this.formats[i], this.locale);
            } else {
                dateParser.applyPattern(this.formats[i]);
            }
            dateParser.setLenient(this.lenient);
            try {
                return dateParser.parse(strValue.toLowerCase());
            }
            catch (ParseException pe) {
                continue;
            }
        }
        if (this.isUseDefault()) {
            return this.defaultValue;
        }
        throw new MorphException("Unable to parse the date " + value);
    }

    public Class morphsTo() {
        return class$java$util$Date == null ? (class$java$util$Date = DateMorpher.class$("java.util.Date")) : class$java$util$Date;
    }

    public void setDefaultValue(Date defaultValue) {
        this.defaultValue = (Date)defaultValue.clone();
    }

    public boolean supports(Class clazz) {
        return (class$java$lang$String == null ? (class$java$lang$String = DateMorpher.class$("java.lang.String")) : class$java$lang$String).isAssignableFrom(clazz);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

