/*
 *  Copyright (C) 2012 Rob Manning
 *  manningr@users.sourceforge.net
 *  
 *  This file is part of MongoDB JDBC Driver.
 *
 *  MongoDB JDBC Driver is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MongoDB JDBC Driver is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MongoDB JDBC Driver.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.mongodb_jdbc_driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Map;

public class MongoDbResultSet implements ResultSet
{
	private String[][] data = null;

	private String[] columnNames = null;

	private int currentRow = -1;

	private String tableName = null;
	
	private boolean isClosed = false;
	
	private MongoDbStatement statement = null;
	
	public MongoDbResultSet()
	{
	}

	public MongoDbResultSet(String[][] data, String[] columnNames)
	{
		if (data != null && data.length > 0 && data[0] != null)
		{
			int numRows = data.length;
			int numColumns = data[0].length;
			this.data = new String[numRows][numColumns];
			for (int i = 0; i < numRows; i++)
			{
				this.data[i] = Arrays.copyOf(data[i], data[i].length);
			}

		}
		this.columnNames = columnNames;
	}

	public void setColumnNames(String[] columnNames)
	{
		this.columnNames = Arrays.copyOf(columnNames, columnNames.length);
	}

	public void setTableName(String tableName) {
		this.tableName = tableName;
	}
	
	public void setStatement(MongoDbStatement statement) {
		this.statement = statement;
	}
	
	public void addResultSet(MongoDbResultSet toCopy)
	{
		if (toCopy.data == null || toCopy.data.length < 0)
		{
			return;
		}
		if (data == null)
		{
			data = new String[toCopy.data.length][toCopy.data[0].length];
			for (int i = 0; i < toCopy.data.length; i++)
			{
				data[i] = Arrays.copyOf(toCopy.data[i], toCopy.data[i].length);
			}
		}
		else
		{
			if (toCopy.data[0].length != data[0].length)
			{
				throw new IllegalArgumentException("Array toCopy column length (" + toCopy.data[0].length
					+ ") is not " + " the same as this result sets column length (" + toCopy.data[0].length + ")");
			}
			String[][] newdata = new String[data.length + toCopy.data.length][data[0].length];
			for (int i = 0; i < data.length; i++)
			{
				newdata[i] = Arrays.copyOf(data[i], data[i].length);
			}
			for (int i = 0; i < toCopy.data.length; i++)
			{
				newdata[data.length+i] = Arrays.copyOf(toCopy.data[i], toCopy.data[i].length);
			}
			data = newdata;
		}
	}

	public void addRow(String[] columnValues)
	{
		if (data == null)
		{
			data = new String[1][columnValues.length];
			data[0] = Arrays.copyOf(columnValues, columnValues.length);
		}
		else
		{
			int numRows = data.length;
			String[][] newdata = new String[numRows + 1][data[0].length];
			for (int i = 0; i < numRows; i++)
			{
				newdata[i] = Arrays.copyOf(data[i], data[i].length);
			}
			newdata[numRows] = Arrays.copyOf(columnValues, columnValues.length);
			data = newdata;
		}
	}
	
	public int getRowCount() {
		if (data == null) {
			return 0;
		}
		return data.length;
	}

	public <T> T unwrap(Class<T> iface) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isWrapperFor(Class<?> iface) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * @see java.sql.ResultSet#next()
	 */
	public boolean next() throws SQLException
	{
		if (data == null)
		{
			return false;
		}
		if (currentRow < data.length - 1)
		{
			currentRow++;
			return true;
		}
		return false;
	}

	/**
	 * @see java.sql.ResultSet#close()
	 */
	public void close() throws SQLException
	{
		this.isClosed = true;
	}

	/**
	 * @see java.sql.ResultSet#wasNull()
	 */
	public boolean wasNull() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public String getString(int columnIndex) throws SQLException
	{
		if (currentRow >= data.length)
		{
			throw new SQLException("ResultSet exhausted, request currentRow = " + currentRow);
		}
		int adjustedColumnIndex = columnIndex - 1;
		if (adjustedColumnIndex >= data[currentRow].length)
		{
			throw new SQLException("Column index does not exist: " + columnIndex);
		}
		return data[currentRow][adjustedColumnIndex];
	}

	public boolean getBoolean(int columnIndex) throws SQLException
	{
		return Boolean.parseBoolean(getString(columnIndex));
	}

	public byte getByte(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	/**
	 * @see java.sql.ResultSet#getShort(int)
	 */
	public short getShort(int columnIndex) throws SQLException
	{
		checkClosed();
		return Short.parseShort(getString(columnIndex));
	}

	/**
	 * @see java.sql.ResultSet#getInt(int)
	 */
	public int getInt(int columnIndex) throws SQLException
	{
		checkClosed();
		return Integer.parseInt(getString(columnIndex));
	}

	/**
	 * @see java.sql.ResultSet#getLong(int)
	 */
	public long getLong(int columnIndex) throws SQLException
	{
		checkClosed();
		return Long.parseLong(getString(columnIndex));
	}

	/**
	 * @see java.sql.ResultSet#getFloat(int)
	 */
	public float getFloat(int columnIndex) throws SQLException
	{
		checkClosed();
		return Float.parseFloat(getString(columnIndex));
	}

	/**
	 * @see java.sql.ResultSet#getDouble(int)
	 */
	public double getDouble(int columnIndex) throws SQLException
	{
		checkClosed();
		return Double.parseDouble(getString(columnIndex));
	}

	public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] getBytes(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Date getDate(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Time getTime(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Timestamp getTimestamp(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public InputStream getAsciiStream(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public InputStream getUnicodeStream(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public InputStream getBinaryStream(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public String getString(String columnLabel) throws SQLException
	{
		checkClosed();
		int index = -1;
		if (columnNames == null) {
			throw new SQLException("Use of columnLabel requires setColumnNames to be called first.");
		}
		for (int i = 0; i < columnNames.length;  i++) {
			if (columnLabel.equals(columnNames[i])) {
				index = i;
				break;
			}
		}
		if (index == -1) {
			throw new SQLException("Column "+columnLabel+" doesn't exist in this ResultSet");
		}
		return getString(index+1);
	}

	public boolean getBoolean(String columnLabel) throws SQLException
	{
		checkClosed();
		// TODO Auto-generated method stub
		return false;
	}

	public byte getByte(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public short getShort(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public int getInt(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public long getLong(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public float getFloat(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public double getDouble(String columnLabel) throws SQLException
	{
		return Double.parseDouble(getString(columnLabel));
	}

	public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public byte[] getBytes(String columnLabel) throws SQLException
	{
		return getString(columnLabel).getBytes();
	}

	public Date getDate(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Time getTime(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Timestamp getTimestamp(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public InputStream getAsciiStream(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public InputStream getUnicodeStream(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public InputStream getBinaryStream(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public SQLWarning getWarnings() throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public void clearWarnings() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public String getCursorName() throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see java.sql.ResultSet#getMetaData()
	 */
	public ResultSetMetaData getMetaData() throws SQLException
	{
		checkClosed();
		
		int[] columnDisplaySizes = new int[columnNames.length];
		for (int i = 0; i < columnDisplaySizes.length; i++) {
			columnDisplaySizes[i] = columnNames[i].length();
		}
		for (String[] row : data) {
			for ( int columnIdx = 0; columnIdx < row.length; columnIdx++) {
				if (row[columnIdx] != null) {
					int datalength = row[columnIdx].length();
					if (datalength > columnDisplaySizes[columnIdx]) {
						columnDisplaySizes[columnIdx] = datalength;
					}
				}
			}
			
		}
		
		return new MongoDbResultSetMetaData(tableName, data, columnNames, columnDisplaySizes);
	}

	public Object getObject(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Object getObject(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public int findColumn(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public Reader getCharacterStream(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Reader getCharacterStream(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public BigDecimal getBigDecimal(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public BigDecimal getBigDecimal(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public boolean isBeforeFirst() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isAfterLast() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isFirst() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean isLast() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public void beforeFirst() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void afterLast() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public boolean first() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean last() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public int getRow() throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public boolean absolute(int row) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean relative(int rows) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean previous() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public void setFetchDirection(int direction) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public int getFetchDirection() throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public void setFetchSize(int rows) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public int getFetchSize() throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	/**
	 * @see java.sql.ResultSet#getType()
	 */
	public int getType() throws SQLException
	{
		return ResultSet.TYPE_FORWARD_ONLY;
	}

	/**
	 * @see java.sql.ResultSet#getConcurrency()
	 */
	public int getConcurrency() throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	public boolean rowUpdated() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean rowInserted() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public boolean rowDeleted() throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	public void updateNull(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBoolean(int columnIndex, boolean x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateByte(int columnIndex, byte x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateShort(int columnIndex, short x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateInt(int columnIndex, int x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateLong(int columnIndex, long x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateFloat(int columnIndex, float x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateDouble(int columnIndex, double x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateString(int columnIndex, String x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBytes(int columnIndex, byte[] x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateDate(int columnIndex, Date x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateTime(int columnIndex, Time x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateObject(int columnIndex, Object x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNull(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBoolean(String columnLabel, boolean x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateByte(String columnLabel, byte x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateShort(String columnLabel, short x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateInt(String columnLabel, int x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateLong(String columnLabel, long x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateFloat(String columnLabel, float x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateDouble(String columnLabel, double x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateString(String columnLabel, String x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBytes(String columnLabel, byte[] x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateDate(String columnLabel, Date x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateTime(String columnLabel, Time x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateObject(String columnLabel, Object x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void insertRow() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateRow() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void deleteRow() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void refreshRow() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void cancelRowUpdates() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void moveToInsertRow() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void moveToCurrentRow() throws SQLException
	{
		// TODO Auto-generated method stub

	}

	/**
	 * @see java.sql.ResultSet#getStatement()
	 */
	public Statement getStatement() throws SQLException
	{
		return this.statement;
	}

	public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Ref getRef(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Blob getBlob(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Clob getClob(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Array getArray(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Ref getRef(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Blob getBlob(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Clob getClob(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Array getArray(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Date getDate(int columnIndex, Calendar cal) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Date getDate(String columnLabel, Calendar cal) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Time getTime(int columnIndex, Calendar cal) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Time getTime(String columnLabel, Calendar cal) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public URL getURL(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public URL getURL(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public void updateRef(int columnIndex, Ref x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateRef(String columnLabel, Ref x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBlob(int columnIndex, Blob x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBlob(String columnLabel, Blob x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateClob(int columnIndex, Clob x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateClob(String columnLabel, Clob x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateArray(int columnIndex, Array x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateArray(String columnLabel, Array x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public RowId getRowId(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public RowId getRowId(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public void updateRowId(int columnIndex, RowId x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateRowId(String columnLabel, RowId x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public int getHoldability() throws SQLException
	{
		// TODO Auto-generated method stub
		return 0;
	}

	/**
	 * @see java.sql.ResultSet#isClosed()
	 */
	public boolean isClosed() throws SQLException
	{
		return isClosed;
	}

	public void updateNString(int columnIndex, String nString) throws SQLException
	{
		checkClosed();
		// TODO Auto-generated method stub

	}

	public void updateNString(String columnLabel, String nString) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNClob(int columnIndex, NClob nClob) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNClob(String columnLabel, NClob nClob) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public NClob getNClob(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public NClob getNClob(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public SQLXML getSQLXML(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public SQLXML getSQLXML(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public String getNString(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public String getNString(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Reader getNCharacterStream(int columnIndex) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public Reader getNCharacterStream(String columnLabel) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateClob(int columnIndex, Reader reader, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateClob(String columnLabel, Reader reader, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateCharacterStream(int columnIndex, Reader x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateClob(int columnIndex, Reader reader) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateClob(String columnLabel, Reader reader) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNClob(int columnIndex, Reader reader) throws SQLException
	{
		// TODO Auto-generated method stub

	}

	public void updateNClob(String columnLabel, Reader reader) throws SQLException
	{
		// TODO Auto-generated method stub

	}
	
	private void checkClosed() throws SQLException
	{
		if (isClosed) {
			throw new SQLException("ResultSet was previously closed.");
		}
	}
}
