/*
 *  Copyright (C) 2012 Rob Manning
 *  manningr@users.sourceforge.net
 *  
 *  This file is part of MongoDB JDBC Driver.
 *
 *  MongoDB JDBC Driver is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  MongoDB JDBC Driver is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with MongoDB JDBC Driver.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.mongodb_jdbc_driver;

import static net.sf.mongodb_jdbc_driver.MongoDbMetaData.DOCUMENT_TYPE_NAME;
import static net.sf.mongodb_jdbc_driver.MongoDbMetaData.OBJECT_ID_TYPE_NAME;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Types;

public class MongoDbResultSetMetaData implements ResultSetMetaData
{

	private final String[][] data;

	private final String[] columnNames;

	private final String tableName;
	
	private final int[] columnDisplaySizes;

	public MongoDbResultSetMetaData(String tableName, String[][] data, String[] columnNames,
		int[] columnDisplaySizes)
	{
		this.tableName = tableName;
		this.data = data;
		this.columnNames = columnNames;
		this.columnDisplaySizes = columnDisplaySizes;
	}

	@Override
	public <T> T unwrap(Class<T> iface) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public boolean isWrapperFor(Class<?> iface) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * @see java.sql.ResultSetMetaData#getColumnCount()
	 */
	@Override
	public int getColumnCount() throws SQLException
	{
		return this.columnNames.length;
	}

	/**
	 * @see java.sql.ResultSetMetaData#isAutoIncrement(int)
	 */
	@Override
	public boolean isAutoIncrement(int column) throws SQLException
	{
		return false;
	}

	@Override
	public boolean isCaseSensitive(int column) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isSearchable(int column) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	@Override
	public boolean isCurrency(int column) throws SQLException
	{
		// TODO Auto-generated method stub
		return false;
	}

	/**
	 * @see java.sql.ResultSetMetaData#isNullable(int)
	 */
	@Override
	public int isNullable(int column) throws SQLException
	{
		return ResultSetMetaData.columnNoNulls;
	}

	/**
	 * @see java.sql.ResultSetMetaData#isSigned(int)
	 */
	@Override
	public boolean isSigned(int column) throws SQLException
	{
		return false;
	}

	/**
	 * @see java.sql.ResultSetMetaData#getColumnDisplaySize(int)
	 */
	@Override
	public int getColumnDisplaySize(int column) throws SQLException
	{
		return columnDisplaySizes[column - 1];
	}

	/**
	 * @see java.sql.ResultSetMetaData#getColumnLabel(int)
	 */
	@Override
	public String getColumnLabel(int column) throws SQLException
	{
		return columnNames[column - 1];
	}

	/**
	 * @see java.sql.ResultSetMetaData#getColumnName(int)
	 */
	@Override
	public String getColumnName(int column) throws SQLException
	{
		// TODO: change this if/when we start supporting AS in select clause.
		return columnNames[column - 1];
	}

	/**
	 * @see java.sql.ResultSetMetaData#getSchemaName(int)
	 */
	@Override
	public String getSchemaName(int column) throws SQLException
	{
		return null;
	}

	@Override
	public int getPrecision(int column) throws SQLException
	{
		return 0;
	}

	/**
	 * @see java.sql.ResultSetMetaData#getScale(int)
	 */
	@Override
	public int getScale(int column) throws SQLException
	{
		return 0;
	}

	/**
	 * @see java.sql.ResultSetMetaData#getTableName(int)
	 */
	@Override
	public String getTableName(int column) throws SQLException
	{
		return tableName;
	}

	@Override
	public String getCatalogName(int column) throws SQLException
	{
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see java.sql.ResultSetMetaData#getColumnType(int)
	 */
	@Override
	public int getColumnType(int column) throws SQLException
	{
		if (columnNames[column - 1].equalsIgnoreCase("DOCUMENT"))
		{
			return Types.VARCHAR;
		}

		return Types.VARCHAR;
	}

	@Override
	public String getColumnTypeName(int column) throws SQLException
	{
		if (columnNames[column - 1].equalsIgnoreCase(DOCUMENT_TYPE_NAME))
		{
			return DOCUMENT_TYPE_NAME;
		}
		if (columnNames[column - 1].equalsIgnoreCase(OBJECT_ID_TYPE_NAME))
		{
			return OBJECT_ID_TYPE_NAME;
		}
		return "VARCHAR";
	}

	/**
	 * @see java.sql.ResultSetMetaData#isReadOnly(int)
	 */
	@Override
	public boolean isReadOnly(int column) throws SQLException
	{
		return false;
	}

	/**
	 * @see java.sql.ResultSetMetaData#isWritable(int)
	 */
	@Override
	public boolean isWritable(int column) throws SQLException
	{
		return true;
	}

	/**
	 * @see java.sql.ResultSetMetaData#isDefinitelyWritable(int)
	 */
	@Override
	public boolean isDefinitelyWritable(int column) throws SQLException
	{
		return true;
	}

	/**
	 * @see java.sql.ResultSetMetaData#getColumnClassName(int)
	 */
	@Override
	public String getColumnClassName(int column) throws SQLException
	{
		return "java.lang.String";
	}

}
