/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mongodb_jdbc_driver;

import java.net.UnknownHostException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import net.sf.mongodb_jdbc_driver.MongoDbMetaData;
import net.sf.mongodb_jdbc_driver.MongoDbStatement;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapper;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapperFactory;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapperFactoryImpl;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.MongoException;

public class MongoDbConnection
implements Connection {
    private final String server;
    private final String url;
    private final int port;
    private String dbName;
    private MongoWrapper mongo;
    private DB db;
    private final Properties connectionProperties;
    private MongoWrapperFactory mongoWrapperFactory = new MongoWrapperFactoryImpl();
    private boolean isClosed = false;
    private boolean isReadOnly = false;

    public MongoDbConnection(String server, int port, String dbName, String url, Properties connectionProperties) throws UnknownHostException {
        this.server = server;
        this.port = port;
        this.dbName = dbName;
        this.url = url;
        this.connectionProperties = connectionProperties;
        this.mongo = this.mongoWrapperFactory.getMongoWrapper(server, port, connectionProperties);
        this.db = this.mongo.getDB(dbName);
    }

    public MongoWrapper getMongoWrapper() {
        return this.mongo;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        return new MongoDbStatement(this);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        this.checkClosed();
        throw new UnsupportedOperationException("MongoDB does not support SQL natively.");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkClosed();
        if (!autoCommit) {
            throw new UnsupportedOperationException("MongoDB provides no support for transactions.");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        this.checkClosed();
        return true;
    }

    @Override
    public void commit() throws SQLException {
        this.checkClosed();
        throw new UnsupportedOperationException("MongoDB provides no support for transactions.");
    }

    @Override
    public void rollback() throws SQLException {
        this.checkClosed();
        throw new UnsupportedOperationException("MongoDB provides no support for transactions.");
    }

    @Override
    public void close() throws SQLException {
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkClosed();
        return new MongoDbMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkClosed();
        this.isReadOnly = readOnly;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        this.checkClosed();
        return this.isReadOnly;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.checkClosed();
        this.dbName = catalog;
        this.db = this.mongo.getDB(this.dbName);
    }

    @Override
    public String getCatalog() throws SQLException {
        this.checkClosed();
        return this.dbName;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.checkClosed();
        throw new UnsupportedOperationException("MongoDB provides no support for transactions.");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return null;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        return null;
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        return null;
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        return null;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        return null;
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        this.checkClosed();
        try {
            this.mongo.getDatabaseNames();
        }
        catch (MongoException e) {
            return false;
        }
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        this.checkClosed();
        return null;
    }

    public String getUrl() {
        return this.url;
    }

    public DB getDb() {
        return this.db;
    }

    public void setMongoWrapperFactory(MongoWrapperFactory mongoWrapperFactory) {
        this.mongoWrapperFactory = mongoWrapperFactory;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Statement was previously closed.");
        }
    }
}

