/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mongodb_jdbc_driver;

import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.mongodb_jdbc_driver.DriverPropertyInfoHelper;
import net.sf.mongodb_jdbc_driver.MongoDbConnection;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapperFactory;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapperFactoryImpl;
import shaded.org.apache.commons.lang3.math.NumberUtils;

public class MongoDbDriver
implements Driver {
    private DriverPropertyInfoHelper propertyInfoHelper = new DriverPropertyInfoHelper();
    private MongoWrapperFactory mongoWrapperFactory = new MongoWrapperFactoryImpl();
    private static final String URL_SPEC = "jdbc:mongodb://<server>[:27017]/<db-name>";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        String[] urlParts = url.split(":");
        if (urlParts.length < 4) {
            return null;
        }
        String serverName = urlParts[2].substring(2);
        String[] dbParts = urlParts[3].split("/");
        String dbName = null;
        int port = 27017;
        if (dbParts.length == 1) {
            dbName = dbParts[0];
        } else {
            port = NumberUtils.toInt(dbParts[0], 27017);
            dbName = dbParts[1];
        }
        MongoDbConnection result = null;
        try {
            result = new MongoDbConnection(serverName, port, dbName, url, info);
            result.setMongoWrapperFactory(this.mongoWrapperFactory);
        }
        catch (UnknownHostException e) {
            throw new SQLException("Unexpected exception: " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        System.err.println("Inside acceptsUrl: " + url);
        return url.startsWith("jdbc:mongodb://");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.propertyInfoHelper.getPropertyInfo();
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    public void setMongoWrapperFactory(MongoWrapperFactory mongoWrapperFactory) {
        this.mongoWrapperFactory = mongoWrapperFactory;
    }

    static {
        try {
            DriverManager.registerDriver(new MongoDbDriver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

