/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mongodb_jdbc_driver;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.List;
import net.sf.mongodb_jdbc_driver.MongoDbConnection;
import net.sf.mongodb_jdbc_driver.MongoDbResultSet;
import net.sf.mongodb_jdbc_driver.ParserHelper;
import net.sf.mongodb_jdbc_driver.zql.ParseException;
import shaded.com.google.gson.Gson;
import shaded.com.google.gson.GsonBuilder;
import shaded.com.google.gson.JsonElement;
import shaded.com.google.gson.JsonParser;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBCursor;
import shaded.com.mongodb.DBObject;

public class MongoDbStatement
implements Statement {
    private final DB db;
    private final MongoDbConnection con;
    private final ParserHelper parserHelper = new ParserHelper();
    private MongoDbResultSet lastResultSet;
    private boolean isClosed = false;
    private int maxRows = -1;

    public MongoDbStatement(MongoDbConnection con) {
        this.db = con.getDb();
        this.con = con;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void checkForSupportedColumn(String selectColumn, String sql) throws SQLException {
        if (!(selectColumn.equals("*") || selectColumn.equals("\"_id\"") || selectColumn.equals("document"))) {
            throw new SQLException("Unsupported select item (" + selectColumn + ") in select column list (" + sql + ")");
        }
    }

    private int getSelectColumnCount(List<String> columns) {
        if (columns.contains("*")) {
            return 2;
        }
        return columns.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        block15: {
            this.lastResultSet = new MongoDbResultSet();
            this.lastResultSet.setStatement(this);
            try {
                if (!this.parserHelper.isSelectQuery(sql)) {
                    throw new SQLException("Statement must be a select query");
                }
                String collectionName = this.parserHelper.getSelectTable(sql);
                DBCollection collection = this.db.getCollection(collectionName);
                List<String> selectColumns = this.parserHelper.getSelectColumns(sql);
                if (selectColumns.size() == 1 && "count(*)".equals(selectColumns.get(0))) {
                    this.lastResultSet.setColumnNames(new String[]{"count(*)"});
                    this.lastResultSet.addRow(new String[]{"" + collection.find().count()});
                    break block15;
                }
                boolean projectId = false;
                boolean projectDocument = false;
                String[] selectColumnNamesArr = new String[this.getSelectColumnCount(selectColumns)];
                int selectColumnNamesArrIdx = 0;
                for (String selectColumn : selectColumns) {
                    this.checkForSupportedColumn(selectColumn, sql);
                    if (selectColumn.equals("*")) {
                        projectId = true;
                        projectDocument = true;
                        selectColumnNamesArr[0] = "\"_id\"";
                        selectColumnNamesArr[1] = "document";
                        break;
                    }
                    if (selectColumn.equals("\"_id\"")) {
                        selectColumnNamesArr[selectColumnNamesArrIdx++] = "\"_id\"";
                        projectId = true;
                    }
                    if (!selectColumn.equals("document")) continue;
                    selectColumnNamesArr[selectColumnNamesArrIdx++] = "document";
                    projectDocument = true;
                }
                this.lastResultSet.setColumnNames(selectColumnNamesArr);
                DBCursor cursor = collection.find();
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                JsonParser jp = new JsonParser();
                try {
                    while (cursor.hasNext() && (this.maxRows == -1 || this.lastResultSet.getRowCount() < this.maxRows)) {
                        DBObject object = cursor.next();
                        String id = object.get("_id").toString();
                        String document = object.toString();
                        if (projectDocument) {
                            JsonElement je = jp.parse(document);
                            document = gson.toJson(je);
                        }
                        if (projectId && projectDocument) {
                            if (selectColumnNamesArr[0].equals("document")) {
                                this.lastResultSet.addRow(new String[]{document, id});
                                continue;
                            }
                            this.lastResultSet.addRow(new String[]{id, document});
                            continue;
                        }
                        if (projectId) {
                            this.lastResultSet.addRow(new String[]{id});
                            continue;
                        }
                        this.lastResultSet.addRow(new String[]{document});
                    }
                }
                finally {
                    cursor.close();
                }
            }
            catch (ParseException e) {
                throw new SQLException("Unable to parse query (" + sql + "): " + e.getMessage(), e);
            }
        }
        return this.lastResultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        throw new SQLException("Update support has not yet been added to this driver");
    }

    @Override
    public void close() throws SQLException {
        if (this.lastResultSet != null) {
            this.lastResultSet.close();
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        return 0;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException("MongoDB provides no support for query timeouts.");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException("MongoDB provides no support for query timeouts.");
    }

    @Override
    public void cancel() throws SQLException {
        this.checkClosed();
        throw new SQLFeatureNotSupportedException("MongoDB provides no support for interrupting an operation.");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.checkClosed();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        this.checkClosed();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkClosed();
        boolean result = false;
        try {
            if (this.parserHelper.isSelectQuery(sql)) {
                this.lastResultSet = (MongoDbResultSet)this.executeQuery(sql);
                result = true;
            }
        }
        catch (ParseException e) {
            throw new SQLException("Unable to parse query (" + sql + ") : " + e.getMessage(), e);
        }
        return result;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClosed();
        return this.lastResultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 0;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetType() throws SQLException {
        return 0;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
    }

    @Override
    public void clearBatch() throws SQLException {
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkClosed();
        return this.con;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkClosed();
        return null;
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return 0;
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Statement was previously closed.");
        }
    }
}

