/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mongodb_jdbc_driver;

import java.io.ByteArrayInputStream;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import net.sf.mongodb_jdbc_driver.zql.ParseException;
import net.sf.mongodb_jdbc_driver.zql.ZDelete;
import net.sf.mongodb_jdbc_driver.zql.ZFromItem;
import net.sf.mongodb_jdbc_driver.zql.ZInsert;
import net.sf.mongodb_jdbc_driver.zql.ZQuery;
import net.sf.mongodb_jdbc_driver.zql.ZSelectItem;
import net.sf.mongodb_jdbc_driver.zql.ZUpdate;
import net.sf.mongodb_jdbc_driver.zql.ZqlParser;

public class ParserHelper {
    private final ZqlParser zqlParser = new ZqlParser();

    public boolean isQueryWithJoin(String sql) throws ParseException {
        this.initParser(sql);
        ZQuery q = (ZQuery)this.zqlParser.readStatement();
        Vector<ZFromItem> v = q.getFrom();
        return v.size() > 1;
    }

    public boolean isSelectQuery(String sql) throws ParseException {
        this.initParser(sql);
        return this.zqlParser.readStatement() instanceof ZQuery;
    }

    public boolean isUpdateQuery(String sql) throws ParseException {
        this.initParser(sql);
        return this.zqlParser.readStatement() instanceof ZUpdate;
    }

    public boolean isInsertQuery(String sql) throws ParseException {
        this.initParser(sql);
        return this.zqlParser.readStatement() instanceof ZInsert;
    }

    public boolean isDeleteQuery(String sql) throws ParseException {
        this.initParser(sql);
        return this.zqlParser.readStatement() instanceof ZDelete;
    }

    public String getSelectTable(String sql) throws ParseException, SQLException {
        this.initParser(sql);
        ZQuery q = (ZQuery)this.zqlParser.readStatement();
        Vector<ZFromItem> v = q.getFrom();
        if (v.size() > 1) {
            throw new SQLException("MongoDB does not support queries with joins");
        }
        if (v.size() < 1) {
            throw new SQLException("The specified query (" + sql + ") does not contain a from clause");
        }
        return v.get(0).getTable();
    }

    public List<String> getSelectColumns(String sql) throws ParseException, SQLException {
        ArrayList<String> result = new ArrayList<String>();
        this.initParser(sql);
        ZQuery q = (ZQuery)this.zqlParser.readStatement();
        Vector<ZSelectItem> v = q.getSelect();
        Enumeration<ZSelectItem> e = v.elements();
        while (e.hasMoreElements()) {
            ZSelectItem selectElement = e.nextElement();
            if (selectElement.getAggregate() != null) {
                result.add(selectElement.getAggregate().toLowerCase() + "(" + selectElement.getColumn() + ")");
                continue;
            }
            result.add(selectElement.getColumn().toLowerCase());
        }
        return result;
    }

    private void initParser(String sql) {
        if (sql.endsWith(";")) {
            this.zqlParser.initParser(new ByteArrayInputStream(sql.getBytes()));
        } else {
            this.zqlParser.initParser(new ByteArrayInputStream((sql + ";").getBytes()));
        }
    }
}

