/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mongodb_jdbc_driver.wrapper;

import java.net.UnknownHostException;
import java.util.List;
import java.util.Properties;
import net.sf.mongodb_jdbc_driver.DriverPropertyInfoHelper;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapper;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapperFactory;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapperImpl;
import shaded.com.mongodb.Mongo;
import shaded.com.mongodb.MongoOptions;
import shaded.com.mongodb.MongoURI;
import shaded.com.mongodb.ServerAddress;

public class MongoWrapperFactoryImpl
implements MongoWrapperFactory {
    private DriverPropertyInfoHelper propInfoHelper = new DriverPropertyInfoHelper();

    @Override
    public MongoWrapper getMongoWrapper(String server, int port, Properties connectionProperties) throws UnknownHostException {
        MongoOptions mongoOptions = this.propInfoHelper.getMongoOptions(connectionProperties);
        ServerAddress addr = new ServerAddress(server, port);
        return new MongoWrapperImpl(addr, mongoOptions);
    }

    @Override
    public MongoWrapper getMongoWrapper(Mongo mongo) {
        return new MongoWrapperImpl(mongo);
    }

    @Override
    public MongoWrapper getMongoWrapper() throws UnknownHostException {
        return new MongoWrapperImpl();
    }

    @Override
    public MongoWrapper getMongoWrapper(String host) throws UnknownHostException {
        return new MongoWrapperImpl(host);
    }

    @Override
    public MongoWrapper getMongoWrapper(ServerAddress addr, MongoOptions options) {
        if (options == null) {
            return new MongoWrapperImpl(addr);
        }
        return new MongoWrapperImpl(addr, options);
    }

    @Override
    public MongoWrapper getMongoWrapper(List<ServerAddress> seeds, MongoOptions options) {
        if (options == null) {
            return new MongoWrapperImpl(seeds);
        }
        return new MongoWrapperImpl(seeds, options);
    }

    @Override
    public MongoWrapper getMongoWrapper(MongoURI uri) throws UnknownHostException {
        return new MongoWrapperImpl(uri);
    }
}

