/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mongodb_jdbc_driver.wrapper;

import java.net.UnknownHostException;
import java.util.Collection;
import java.util.List;
import net.sf.mongodb_jdbc_driver.wrapper.MongoWrapper;
import shaded.com.mongodb.CommandResult;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBAddress;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DBTCPConnector;
import shaded.com.mongodb.Mongo;
import shaded.com.mongodb.MongoOptions;
import shaded.com.mongodb.MongoURI;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.ReplicaSetStatus;
import shaded.com.mongodb.ServerAddress;
import shaded.com.mongodb.WriteConcern;

public class MongoWrapperImpl
implements MongoWrapper {
    private final Mongo mongo;

    public static int getMajorVersion() {
        return Mongo.getMajorVersion();
    }

    public static int getMinorVersion() {
        return Mongo.getMajorVersion();
    }

    public static DB connect(DBAddress addr) {
        return new MongoWrapperImpl(addr).getDB(addr.getDBName());
    }

    public MongoWrapperImpl(Mongo mongo) {
        this.mongo = mongo;
    }

    public MongoWrapperImpl() throws UnknownHostException {
        this.mongo = new Mongo();
    }

    public MongoWrapperImpl(String host) throws UnknownHostException {
        this.mongo = new Mongo(host);
    }

    public MongoWrapperImpl(String host, MongoOptions options) throws UnknownHostException {
        this.mongo = new Mongo(host, options);
    }

    public MongoWrapperImpl(String host, int port) throws UnknownHostException {
        this.mongo = new Mongo(host, port);
    }

    public MongoWrapperImpl(ServerAddress addr) {
        this.mongo = new Mongo(addr);
    }

    public MongoWrapperImpl(ServerAddress addr, MongoOptions options) {
        this.mongo = new Mongo(addr, options);
    }

    public MongoWrapperImpl(List<ServerAddress> seeds) {
        this.mongo = new Mongo(seeds);
    }

    public MongoWrapperImpl(List<ServerAddress> seeds, MongoOptions options) {
        this.mongo = new Mongo(seeds, options);
    }

    public MongoWrapperImpl(MongoURI uri) throws UnknownHostException {
        this.mongo = new Mongo(uri);
    }

    @Override
    public DB getDB(String dbname) {
        return this.mongo.getDB(dbname);
    }

    @Override
    public Collection<DB> getUsedDatabases() {
        return this.mongo.getUsedDatabases();
    }

    @Override
    public List<String> getDatabaseNames() {
        return this.mongo.getDatabaseNames();
    }

    @Override
    public void dropDatabase(String dbName) {
        this.mongo.dropDatabase(dbName);
    }

    @Override
    public String getVersion() {
        return this.mongo.getVersion();
    }

    @Override
    public String debugString() {
        return this.mongo.debugString();
    }

    @Override
    public String getConnectPoint() {
        return this.mongo.getConnectPoint();
    }

    @Override
    public DBTCPConnector getConnector() {
        return this.mongo.getConnector();
    }

    @Override
    public ReplicaSetStatus getReplicaSetStatus() {
        return this.mongo.getReplicaSetStatus();
    }

    @Override
    public ServerAddress getAddress() {
        return this.mongo.getAddress();
    }

    @Override
    public List<ServerAddress> getAllAddress() {
        return this.mongo.getAllAddress();
    }

    @Override
    public List<ServerAddress> getServerAddressList() {
        return this.mongo.getServerAddressList();
    }

    @Override
    public void close() {
        this.mongo.close();
    }

    @Override
    public void setWriteConcern(WriteConcern concern) {
        this.mongo.setWriteConcern(concern);
    }

    @Override
    public WriteConcern getWriteConcern() {
        return this.mongo.getWriteConcern();
    }

    @Override
    public void setReadPreference(ReadPreference preference) {
        this.mongo.setReadPreference(preference);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.mongo.getReadPreference();
    }

    @Override
    @Deprecated
    public void slaveOk() {
        this.addOption(4);
    }

    @Override
    public void addOption(int option) {
        this.mongo.addOption(option);
    }

    @Override
    public void setOptions(int options) {
        this.mongo.setOptions(options);
    }

    @Override
    public void resetOptions() {
        this.mongo.resetOptions();
    }

    @Override
    public int getOptions() {
        return this.mongo.getOptions();
    }

    @Override
    public MongoOptions getMongoOptions() {
        return this.mongo.getMongoOptions();
    }

    @Override
    public int getMaxBsonObjectSize() {
        return this.mongo.getMaxBsonObjectSize();
    }

    @Override
    public CommandResult fsync(boolean async) {
        return this.mongo.fsync(async);
    }

    @Override
    public CommandResult fsyncAndLock() {
        return this.mongo.fsyncAndLock();
    }

    @Override
    public DBObject unlock() {
        return this.mongo.unlock();
    }

    @Override
    public boolean isLocked() {
        return this.mongo.isLocked();
    }

    @Override
    public String toString() {
        return this.mongo.toString();
    }
}

