/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.MongoException;
import shaded.com.mongodb.ServerAddress;
import shaded.com.mongodb.ServerError;

public class CommandResult
extends BasicDBObject {
    private final DBObject _cmd;
    private final ServerAddress _host;
    private static final long serialVersionUID = 1L;

    CommandResult(ServerAddress srv) {
        this(null, srv);
    }

    CommandResult(DBObject cmd, ServerAddress srv) {
        if (srv == null) {
            throw new IllegalArgumentException("server address is null");
        }
        this._cmd = cmd;
        this._host = srv;
        this.put("serverUsed", (Object)srv.toString());
    }

    public boolean ok() {
        Object o = this.get("ok");
        if (o == null) {
            throw new IllegalArgumentException("'ok' should never be null...");
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue() == 1;
        }
        throw new IllegalArgumentException("can't figure out what to do with: " + o.getClass().getName());
    }

    public String getErrorMessage() {
        Object foo = this.get("errmsg");
        if (foo == null) {
            return null;
        }
        return foo.toString();
    }

    public MongoException getException() {
        if (!this.ok()) {
            StringBuilder buf = new StringBuilder();
            if (this._cmd != null) {
                String cmdName = this._cmd.keySet().iterator().next();
                buf.append("command failed [").append(cmdName).append("]: ");
            } else {
                buf.append("operation failed: ");
            }
            buf.append(this.toString());
            return new CommandFailure(this, buf.toString());
        }
        if (this.hasErr()) {
            Object foo = this.get("err");
            int code = this.getCode();
            String s = foo.toString();
            if (code == 11000 || code == 11001 || s.startsWith("E11000") || s.startsWith("E11001")) {
                return new MongoException.DuplicateKey(code, s);
            }
            return new MongoException(code, s);
        }
        return null;
    }

    private int getCode() {
        int code = -1;
        if (this.get("code") instanceof Number) {
            code = ((Number)this.get("code")).intValue();
        }
        return code;
    }

    boolean hasErr() {
        Object o = this.get("err");
        return o != null && ((String)o).length() > 0;
    }

    public void throwOnError() {
        if (!this.ok() || this.hasErr()) {
            throw this.getException();
        }
    }

    public ServerAddress getServerUsed() {
        return this._host;
    }

    static class CommandFailure
    extends MongoException {
        private static final long serialVersionUID = 1L;

        public CommandFailure(CommandResult res, String msg) {
            super(ServerError.getCode(res), msg);
        }
    }
}

