/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.Bytes;
import shaded.com.mongodb.CommandResult;
import shaded.com.mongodb.ConnectionStatus;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBConnector;
import shaded.com.mongodb.DBDecoder;
import shaded.com.mongodb.DBPort;
import shaded.com.mongodb.DBPortPool;
import shaded.com.mongodb.DynamicConnectionStatus;
import shaded.com.mongodb.Mongo;
import shaded.com.mongodb.MongoException;
import shaded.com.mongodb.OutMessage;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.ReplicaSetStatus;
import shaded.com.mongodb.Response;
import shaded.com.mongodb.ServerAddress;
import shaded.com.mongodb.ServerError;
import shaded.com.mongodb.WriteConcern;
import shaded.com.mongodb.WriteResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBTCPConnector
implements DBConnector {
    static Logger _logger = Logger.getLogger(Bytes.LOGGER.getName() + ".tcp");
    static Logger _createLogger = Logger.getLogger(_logger.getName() + ".connect");
    private volatile DBPortPool _masterPortPool;
    private final Mongo _mongo;
    private DBPortPool.Holder _portHolder;
    private final List<ServerAddress> _allHosts;
    private DynamicConnectionStatus _connectionStatus;
    private final AtomicBoolean _closed = new AtomicBoolean(false);
    private volatile int _maxBsonObjectSize;
    private volatile Boolean _isMongosDirectConnection;
    private ThreadLocal<MyPort> _myPort = new ThreadLocal<MyPort>(){

        @Override
        protected MyPort initialValue() {
            return new MyPort();
        }
    };

    public DBTCPConnector(Mongo m, ServerAddress addr) {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(addr);
        _createLogger.info(addr.toString());
        this.setMasterAddress(addr);
        this._allHosts = null;
    }

    public DBTCPConnector(Mongo m, ServerAddress ... all) {
        this(m, Arrays.asList(all));
    }

    public DBTCPConnector(Mongo m, List<ServerAddress> all) {
        this._mongo = m;
        this._portHolder = new DBPortPool.Holder(m._options);
        DBTCPConnector._checkAddress(all);
        this._allHosts = new ArrayList<ServerAddress>(all);
        _createLogger.info(all + " -> " + this.getAddress());
        this._connectionStatus = new DynamicConnectionStatus(m, this._allHosts);
    }

    public void start() {
        if (this._connectionStatus != null) {
            this._connectionStatus.start();
        }
    }

    private static ServerAddress _checkAddress(ServerAddress addr) {
        if (addr == null) {
            throw new NullPointerException("address can't be null");
        }
        return addr;
    }

    private static ServerAddress _checkAddress(List<ServerAddress> addrs) {
        if (addrs == null) {
            throw new NullPointerException("addresses can't be null");
        }
        if (addrs.size() == 0) {
            throw new IllegalArgumentException("need to specify at least 1 address");
        }
        return addrs.get(0);
    }

    @Override
    public void requestStart() {
        this._myPort.get().requestStart();
    }

    @Override
    public void requestDone() {
        this._myPort.get().requestDone();
    }

    @Override
    public void requestEnsureConnection() {
        this.checkMaster(false, true);
        this._myPort.get().requestEnsureConnection();
    }

    void _checkClosed() {
        if (this._closed.get()) {
            throw new IllegalStateException("this Mongo has been closed");
        }
    }

    WriteResult _checkWriteError(DB db, DBPort port, WriteConcern concern) throws IOException {
        CommandResult e = port.runCommand(db, concern.getCommand());
        e.throwOnError();
        return new WriteResult(e, concern);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern) {
        return this.say(db, m, concern, null);
    }

    @Override
    public WriteResult say(DB db, OutMessage m, WriteConcern concern, ServerAddress hostNeeded) {
        if (concern == null) {
            throw new IllegalArgumentException("Write concern is null");
        }
        this._checkClosed();
        this.checkMaster(false, true);
        MyPort mp = this._myPort.get();
        DBPort port = mp.get(true, ReadPreference.primary(), hostNeeded);
        try {
            port.checkAuth(db);
            port.say(m);
            if (concern.callGetLastError()) {
                WriteResult writeResult = this._checkWriteError(db, port, concern);
                return writeResult;
            }
            WriteResult writeResult = new WriteResult(db, port, concern);
            return writeResult;
        }
        catch (IOException ioe) {
            mp.error(port, ioe);
            this._error(ioe, false);
            if (concern.raiseNetworkErrors()) {
                throw new MongoException.Network("can't say something", ioe);
            }
            CommandResult res = new CommandResult(port.serverAddress());
            res.put("ok", (Object)false);
            res.put("$err", (Object)"NETWORK ERROR");
            WriteResult writeResult = new WriteResult(res, concern);
            return writeResult;
        }
        catch (MongoException me) {
            throw me;
        }
        catch (RuntimeException re) {
            mp.error(port, re);
            throw re;
        }
        finally {
            mp.done(port);
            m.doneWithMessage();
        }
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, DBDecoder decoder) {
        return this.call(db, coll, m, hostNeeded, 2, null, decoder);
    }

    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries) {
        return this.call(db, coll, m, hostNeeded, retries, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response call(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries, ReadPreference readPref, DBDecoder decoder) {
        try {
            Response response = this.innerCall(db, coll, m, hostNeeded, retries, readPref, decoder);
            return response;
        }
        finally {
            m.doneWithMessage();
        }
    }

    private Response innerCall(DB db, DBCollection coll, OutMessage m, ServerAddress hostNeeded, int retries, ReadPreference readPref, DBDecoder decoder) {
        if (readPref == null) {
            readPref = ReadPreference.primary();
        }
        if (readPref == ReadPreference.primary() && m.hasOption(4)) {
            readPref = ReadPreference.secondaryPreferred();
        }
        boolean secondaryOk = readPref != ReadPreference.primary();
        this._checkClosed();
        if (!secondaryOk || this.getReplicaSetStatus() == null) {
            this.checkMaster(false, !secondaryOk);
        }
        MyPort mp = this._myPort.get();
        DBPort port = mp.get(false, readPref, hostNeeded);
        Response res = null;
        boolean retry = false;
        try {
            port.checkAuth(db);
            res = port.call(m, coll, decoder);
            if (res._responseTo != m.getId()) {
                throw new MongoException("ids don't match");
            }
        }
        catch (IOException ioe) {
            mp.error(port, ioe);
            boolean bl = retry = retries > 0 && !coll._name.equals("$cmd") && !(ioe instanceof SocketTimeoutException) && this._error(ioe, secondaryOk);
            if (!retry) {
                throw new MongoException.Network("can't call something : " + port.host() + "/" + db, ioe);
            }
        }
        catch (RuntimeException re) {
            mp.error(port, re);
            throw re;
        }
        finally {
            mp.done(port);
        }
        if (retry) {
            return this.innerCall(db, coll, m, hostNeeded, retries - 1, readPref, decoder);
        }
        ServerError err = res.getError();
        if (err != null && err.isNotMasterError()) {
            this.checkMaster(true, true);
            if (retries <= 0) {
                throw new MongoException("not talking to master and retries used up");
            }
            return this.innerCall(db, coll, m, hostNeeded, retries - 1, readPref, decoder);
        }
        return res;
    }

    public ServerAddress getAddress() {
        DBPortPool pool = this._masterPortPool;
        return pool != null ? pool.getServerAddress() : null;
    }

    public List<ServerAddress> getAllAddress() {
        return this._allHosts;
    }

    public List<ServerAddress> getServerAddressList() {
        if (this._connectionStatus != null) {
            return this._connectionStatus.getServerAddressList();
        }
        ServerAddress master = this.getAddress();
        if (master != null) {
            ArrayList<ServerAddress> list = new ArrayList<ServerAddress>();
            list.add(master);
            return list;
        }
        return null;
    }

    public ReplicaSetStatus getReplicaSetStatus() {
        if (this._connectionStatus == null) {
            return null;
        }
        return this._connectionStatus.asReplicaSetStatus();
    }

    boolean isMongosConnection() {
        if (this._connectionStatus != null) {
            return this._connectionStatus.asMongosStatus() != null;
        }
        if (this._isMongosDirectConnection == null) {
            this.initDirectConnection();
        }
        return this._isMongosDirectConnection != null ? this._isMongosDirectConnection : false;
    }

    public String getConnectPoint() {
        ServerAddress master = this.getAddress();
        return master != null ? master.toString() : null;
    }

    boolean _error(Throwable t, boolean secondaryOk) {
        if (this._connectionStatus == null) {
            return false;
        }
        if (this._connectionStatus.hasServerUp()) {
            this.checkMaster(true, !secondaryOk);
        }
        return this._connectionStatus.hasServerUp();
    }

    void checkMaster(boolean force, boolean failIfNoMaster) {
        if (this._connectionStatus != null) {
            if (this._masterPortPool == null || force) {
                ConnectionStatus.Node master = this._connectionStatus.ensureMaster();
                if (master == null) {
                    if (failIfNoMaster) {
                        throw new MongoException("can't find a master");
                    }
                } else {
                    this.setMaster(master);
                }
            }
        } else if (this._maxBsonObjectSize == 0) {
            this.initDirectConnection();
        }
    }

    synchronized void setMaster(ConnectionStatus.Node master) {
        if (this._closed.get()) {
            return;
        }
        this.setMasterAddress(master.getServerAddress());
        this._maxBsonObjectSize = master.getMaxBsonObjectSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDirectConnection() {
        if (this._masterPortPool == null) {
            return;
        }
        DBPort port = this._masterPortPool.get();
        try {
            CommandResult res = port.runCommand(this._mongo.getDB("admin"), new BasicDBObject("isMaster", (Object)1));
            this._maxBsonObjectSize = res.containsField("maxBsonObjectSize") ? (Integer)res.get("maxBsonObjectSize") : 0x400000;
            String msg = res.getString("msg");
            this._isMongosDirectConnection = msg != null && msg.equals("isdbgrid");
        }
        catch (Exception e) {
            _logger.log(Level.WARNING, "Exception executing isMaster command on " + port.serverAddress(), e);
        }
        finally {
            port.getPool().done(port);
        }
    }

    private synchronized boolean setMasterAddress(ServerAddress addr) {
        DBPortPool newPool = this._portHolder.get(addr);
        if (newPool == this._masterPortPool) {
            return false;
        }
        if (this._masterPortPool != null) {
            _logger.log(Level.WARNING, "Primary switching from " + this._masterPortPool.getServerAddress() + " to " + addr);
        }
        this._masterPortPool = newPool;
        return true;
    }

    public String debugString() {
        StringBuilder buf = new StringBuilder("DBTCPConnector: ");
        if (this._connectionStatus != null) {
            buf.append("set : ").append(this._allHosts);
        } else {
            ServerAddress master = this.getAddress();
            buf.append(master).append(" ").append(master != null ? master.getSocketAddress() : null);
        }
        return buf.toString();
    }

    public void close() {
        this._closed.set(true);
        if (this._portHolder != null) {
            try {
                this._portHolder.close();
                this._portHolder = null;
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this._connectionStatus != null) {
            try {
                this._connectionStatus.close();
                this._connectionStatus = null;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this._myPort.remove();
    }

    public void updatePortPool(ServerAddress addr) {
        this._portHolder._pools.remove(addr);
    }

    public DBPortPool getDBPortPool(ServerAddress addr) {
        return this._portHolder.get(addr);
    }

    @Override
    public boolean isOpen() {
        return !this._closed.get();
    }

    public int getMaxBsonObjectSize() {
        return this._maxBsonObjectSize;
    }

    MyPort getMyPort() {
        return this._myPort.get();
    }

    class MyPort {
        DBPort _requestPort;
        boolean _inRequest;

        MyPort() {
        }

        DBPort get(boolean keep, ReadPreference readPref, ServerAddress hostNeeded) {
            DBPort p;
            if (hostNeeded != null) {
                if (this._requestPort != null && this._requestPort.serverAddress().equals(hostNeeded)) {
                    return this._requestPort;
                }
                return DBTCPConnector.this._portHolder.get(hostNeeded).get();
            }
            if (this._requestPort != null) {
                if (this._requestPort.getPool() == DBTCPConnector.this._masterPortPool || !keep) {
                    return this._requestPort;
                }
                this._requestPort.getPool().done(this._requestPort);
                this._requestPort = null;
            }
            if (DBTCPConnector.this.getReplicaSetStatus() == null) {
                if (DBTCPConnector.this._masterPortPool == null) {
                    throw new MongoException("Rare case where master=null, probably all servers are down");
                }
                p = DBTCPConnector.this._masterPortPool.get();
            } else {
                ReplicaSetStatus.ReplicaSet replicaSet = DBTCPConnector.this.getReplicaSetStatus()._replicaSetHolder.get();
                ReplicaSetStatus.ReplicaSetNode node = readPref.getNode(replicaSet);
                if (node == null) {
                    throw new MongoException("No replica set members available in " + replicaSet + " for " + readPref.toDBObject().toString());
                }
                p = DBTCPConnector.this._portHolder.get(node.getServerAddress()).get();
            }
            if (this._inRequest) {
                this._requestPort = p;
            }
            return p;
        }

        void done(DBPort p) {
            if (p != this._requestPort) {
                p.getPool().done(p);
            }
        }

        void error(DBPort p, Exception e) {
            ConnectionStatus.Node newMaster;
            p.close();
            this._requestPort = null;
            boolean recoverable = p.getPool().gotError(e);
            if (!recoverable && DBTCPConnector.this._connectionStatus != null && ((DBTCPConnector)DBTCPConnector.this)._masterPortPool._addr.equals(p.serverAddress()) && (newMaster = DBTCPConnector.this._connectionStatus.ensureMaster()) != null) {
                DBTCPConnector.this.setMaster(newMaster);
            }
        }

        void requestEnsureConnection() {
            if (!this._inRequest) {
                return;
            }
            if (this._requestPort != null) {
                return;
            }
            this._requestPort = DBTCPConnector.this._masterPortPool.get();
        }

        void requestStart() {
            this._inRequest = true;
        }

        void requestDone() {
            if (this._requestPort != null) {
                this._requestPort.getPool().done(this._requestPort);
            }
            this._requestPort = null;
            this._inRequest = false;
        }
    }
}

