/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import shaded.com.mongodb.BasicDBList;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.Bytes;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCallback;
import shaded.com.mongodb.DBCallbackFactory;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DBPointer;
import shaded.com.mongodb.DBRef;
import shaded.com.mongodb.MongoInternalException;
import shaded.org.bson.BSONObject;
import shaded.org.bson.BasicBSONCallback;
import shaded.org.bson.types.ObjectId;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDBCallback
extends BasicBSONCallback
implements DBCallback {
    public static DBCallbackFactory FACTORY = new DefaultFactory();
    private String _lastName;
    final DBCollection _collection;
    final DB _db;
    static final Logger LOGGER = Logger.getLogger("com.mongo.DECODING");

    public DefaultDBCallback(DBCollection coll) {
        this._collection = coll;
        this._db = this._collection == null ? null : this._collection.getDB();
    }

    @Override
    public void gotDBRef(String name, String ns, ObjectId id) {
        if (id.equals(Bytes.COLLECTION_REF_ID)) {
            this.cur().put(name, this._collection);
        } else {
            this.cur().put(name, new DBPointer((DBObject)this.cur(), name, this._db, ns, id));
        }
    }

    @Override
    public void objectStart(boolean array, String name) {
        this._lastName = name;
        super.objectStart(array, name);
    }

    @Override
    public Object objectDone() {
        BSONObject o = (BSONObject)super.objectDone();
        if (!(o instanceof List) && o.containsField("$ref") && o.containsField("$id")) {
            return this.cur().put(this._lastName, new DBRef(this._db, o));
        }
        return o;
    }

    @Override
    public BSONObject create() {
        return this._create(null);
    }

    @Override
    public BSONObject create(boolean array, List<String> path) {
        if (array) {
            return new BasicDBList();
        }
        return this._create(path);
    }

    private DBObject _create(List<String> path) {
        Class c = null;
        if (this._collection != null && this._collection._objectClass != null) {
            if (path == null || path.size() == 0) {
                c = this._collection._objectClass;
            } else {
                StringBuilder buf = new StringBuilder();
                for (int i = 0; i < path.size(); ++i) {
                    if (i > 0) {
                        buf.append(".");
                    }
                    buf.append(path.get(i));
                }
                c = this._collection.getInternalClass(buf.toString());
            }
        }
        if (c != null) {
            try {
                return (DBObject)c.newInstance();
            }
            catch (InstantiationException ie) {
                LOGGER.log(Level.FINE, "can't create a: " + c, ie);
                throw new MongoInternalException("can't instantiate a : " + c, ie);
            }
            catch (IllegalAccessException iae) {
                LOGGER.log(Level.FINE, "can't create a: " + c, iae);
                throw new MongoInternalException("can't instantiate a : " + c, iae);
            }
        }
        return new BasicDBObject();
    }

    DBObject dbget() {
        return (DBObject)this.get();
    }

    @Override
    public void reset() {
        this._lastName = null;
        super.reset();
    }

    static class DefaultFactory
    implements DBCallbackFactory {
        DefaultFactory() {
        }

        public DBCallback create(DBCollection collection) {
            return new DefaultDBCallback(collection);
        }
    }
}

