/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import shaded.com.mongodb.DBEncoder;
import shaded.com.mongodb.DBEncoderFactory;
import shaded.com.mongodb.DBPointer;
import shaded.com.mongodb.DBRefBase;
import shaded.org.bson.BSONObject;
import shaded.org.bson.BasicBSONEncoder;
import shaded.org.bson.io.OutputBuffer;
import shaded.org.bson.types.ObjectId;

public class DefaultDBEncoder
extends BasicBSONEncoder
implements DBEncoder {
    public static DBEncoderFactory FACTORY = new DefaultFactory();

    public int writeObject(OutputBuffer buf, BSONObject o) {
        this.set(buf);
        int x = super.putObject(o);
        this.done();
        return x;
    }

    protected boolean putSpecial(String name, Object val) {
        if (val instanceof DBPointer) {
            DBPointer r = (DBPointer)val;
            this.putDBPointer(name, r._ns, (ObjectId)r._id);
            return true;
        }
        if (val instanceof DBRefBase) {
            this.putDBRef(name, (DBRefBase)val);
            return true;
        }
        return false;
    }

    protected void putDBPointer(String name, String ns, ObjectId oid) {
        this._put((byte)12, name);
        this._putValueString(ns);
        this._buf.writeInt(oid._time());
        this._buf.writeInt(oid._machine());
        this._buf.writeInt(oid._inc());
    }

    protected void putDBRef(String name, DBRefBase ref) {
        this._put((byte)3, name);
        int sizePos = this._buf.getPosition();
        this._buf.writeInt(0);
        this._putObjectField("$ref", ref.getRef());
        this._putObjectField("$id", ref.getId());
        this._buf.write(0);
        this._buf.writeInt(sizePos, this._buf.getPosition() - sizePos);
    }

    static class DefaultFactory
    implements DBEncoderFactory {
        DefaultFactory() {
        }

        public DBEncoder create() {
            return new DefaultDBEncoder();
        }
    }
}

