/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.util.Iterator;
import java.util.logging.Logger;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCallback;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBRef;
import shaded.com.mongodb.LazyDBObject;
import shaded.org.bson.LazyBSONCallback;
import shaded.org.bson.types.ObjectId;

public class LazyDBCallback
extends LazyBSONCallback
implements DBCallback {
    final DBCollection _collection;
    final DB _db;
    private static final Logger log = Logger.getLogger(LazyDBCallback.class.getName());

    public LazyDBCallback(DBCollection coll) {
        this._collection = coll;
        this._db = this._collection == null ? null : this._collection.getDB();
    }

    public Object createObject(byte[] data, int offset) {
        LazyDBObject o = new LazyDBObject(data, offset, (LazyBSONCallback)this);
        Iterator<String> it = o.keySet().iterator();
        if (it.hasNext() && it.next().equals("$ref") && o.containsField("$id")) {
            return new DBRef(this._db, o);
        }
        return o;
    }

    public Object createDBRef(String ns, ObjectId id) {
        return new DBRef(this._db, ns, id);
    }
}

