/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.io.IOException;
import java.io.InputStream;
import shaded.com.mongodb.DBCallback;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBDecoder;
import shaded.com.mongodb.DBDecoderFactory;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.LazyDBCallback;
import shaded.org.bson.BSONCallback;
import shaded.org.bson.LazyBSONDecoder;

public class LazyDBDecoder
extends LazyBSONDecoder
implements DBDecoder {
    public static DBDecoderFactory FACTORY = new LazyDBDecoderFactory();

    public DBCallback getDBCallback(DBCollection collection) {
        return new LazyDBCallback(collection);
    }

    public DBObject decode(byte[] b, DBCollection collection) {
        DBCallback cbk = this.getDBCallback(collection);
        cbk.reset();
        this.decode(b, (BSONCallback)cbk);
        return (DBObject)cbk.get();
    }

    public DBObject decode(InputStream in, DBCollection collection) throws IOException {
        DBCallback cbk = this.getDBCallback(collection);
        cbk.reset();
        this.decode(in, (BSONCallback)cbk);
        return (DBObject)cbk.get();
    }

    static class LazyDBDecoderFactory
    implements DBDecoderFactory {
        LazyDBDecoderFactory() {
        }

        public DBDecoder create() {
            return new LazyDBDecoder();
        }
    }
}

