/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.io.IOException;
import shaded.com.mongodb.DBEncoder;
import shaded.com.mongodb.LazyDBObject;
import shaded.com.mongodb.MongoException;
import shaded.org.bson.BSONObject;
import shaded.org.bson.io.OutputBuffer;

public class LazyDBEncoder
implements DBEncoder {
    public int writeObject(OutputBuffer buf, BSONObject o) {
        if (!(o instanceof LazyDBObject)) {
            throw new IllegalArgumentException("LazyDBEncoder can only encode BSONObject instances of type LazyDBObject");
        }
        LazyDBObject lazyDBObject = (LazyDBObject)o;
        try {
            lazyDBObject.pipe(buf);
        }
        catch (IOException e) {
            throw new MongoException("Exception serializing a LazyDBObject", e);
        }
        return lazyDBObject.getBSONSize();
    }
}

