/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.CommandResult;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.ServerAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapReduceOutput {
    final CommandResult _commandResult;
    final String _collname;
    String _dbname = null;
    final Iterable<DBObject> _resultSet;
    final DBCollection _coll;
    final BasicDBObject _counts;
    final DBObject _cmd;

    public MapReduceOutput(DBCollection from, DBObject cmd, CommandResult raw) {
        this._commandResult = raw;
        this._cmd = cmd;
        if (raw.containsField("results")) {
            this._coll = null;
            this._collname = null;
            this._resultSet = (Iterable)raw.get("results");
        } else {
            Object res = raw.get("result");
            if (res instanceof String) {
                this._collname = (String)res;
            } else {
                BasicDBObject output = (BasicDBObject)res;
                this._collname = output.getString("collection");
                this._dbname = output.getString("db");
            }
            DB db = from._db;
            if (this._dbname != null) {
                db = db.getSisterDB(this._dbname);
            }
            this._coll = db.getCollection(this._collname);
            this._coll.setOptions(this._coll.getOptions() & 0xFFFFFFFB);
            this._resultSet = this._coll.find();
        }
        this._counts = (BasicDBObject)raw.get("counts");
    }

    public Iterable<DBObject> results() {
        return this._resultSet;
    }

    public void drop() {
        if (this._coll != null) {
            this._coll.drop();
        }
    }

    public DBCollection getOutputCollection() {
        return this._coll;
    }

    @Deprecated
    public BasicDBObject getRaw() {
        return this._commandResult;
    }

    public CommandResult getCommandResult() {
        return this._commandResult;
    }

    public DBObject getCommand() {
        return this._cmd;
    }

    public ServerAddress getServerUsed() {
        return this._commandResult.getServerUsed();
    }

    public String toString() {
        return this._commandResult.toString();
    }
}

