/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.net.UnknownHostException;
import java.util.List;
import shaded.com.mongodb.Mongo;
import shaded.com.mongodb.MongoClientOptions;
import shaded.com.mongodb.MongoClientURI;
import shaded.com.mongodb.MongoOptions;
import shaded.com.mongodb.MongoURI;
import shaded.com.mongodb.ServerAddress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoClient
extends Mongo {
    public MongoClient() throws UnknownHostException {
        this(new ServerAddress());
    }

    public MongoClient(String host) throws UnknownHostException {
        this(new ServerAddress(host));
    }

    public MongoClient(String host, MongoClientOptions options) throws UnknownHostException {
        this(new ServerAddress(host), options);
    }

    public MongoClient(String host, int port) throws UnknownHostException {
        this(new ServerAddress(host, port));
    }

    public MongoClient(ServerAddress addr) {
        this(addr, new MongoClientOptions.Builder().build());
    }

    public MongoClient(ServerAddress addr, MongoClientOptions options) {
        super(addr, new MongoOptions(options));
    }

    public MongoClient(List<ServerAddress> seeds) {
        this(seeds, new MongoClientOptions.Builder().build());
    }

    public MongoClient(List<ServerAddress> seeds, MongoClientOptions options) {
        super(seeds, new MongoOptions(options));
    }

    public MongoClient(MongoClientURI uri) throws UnknownHostException {
        super(new MongoURI(uri));
    }
}

