/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.MongoClientOptions;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.WriteConcern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoClientURI {
    private static final String PREFIX = "mongodb://";
    final String userName;
    final char[] password;
    final List<String> _hosts;
    final String database;
    final String collection;
    final String _uri;
    private MongoClientOptions _options;
    static final Logger LOGGER = Logger.getLogger("shaded.com.mongodb.MongoURI");

    public MongoClientURI(String uri) {
        this(uri, new MongoClientOptions.Builder());
    }

    MongoClientURI(String uri, MongoClientOptions.Builder builder) {
        String optionsPart;
        String nsPart;
        String serverPart;
        this._uri = uri;
        if (!uri.startsWith(PREFIX)) {
            throw new IllegalArgumentException("uri needs to start with mongodb://");
        }
        int idx = (uri = uri.substring(PREFIX.length())).lastIndexOf("/");
        if (idx < 0) {
            if (uri.contains("?")) {
                throw new IllegalArgumentException("URI contains options without trailing slash");
            }
            serverPart = uri;
            nsPart = null;
            optionsPart = "";
        } else {
            serverPart = uri.substring(0, idx);
            nsPart = uri.substring(idx + 1);
            if ((idx = nsPart.indexOf("?")) >= 0) {
                optionsPart = nsPart.substring(idx + 1);
                nsPart = nsPart.substring(0, idx);
            } else {
                optionsPart = "";
            }
        }
        LinkedList all = new LinkedList();
        int idx2 = serverPart.indexOf("@");
        if (idx2 > 0) {
            String authPart = serverPart.substring(0, idx2);
            serverPart = serverPart.substring(idx2 + 1);
            idx2 = authPart.indexOf(":");
            this.userName = authPart.substring(0, idx2);
            this.password = authPart.substring(idx2 + 1).toCharArray();
        } else {
            this.userName = null;
            this.password = null;
        }
        Collections.addAll(all, serverPart.split(","));
        this._hosts = Collections.unmodifiableList(all);
        if (nsPart != null) {
            idx = nsPart.indexOf(".");
            if (idx < 0) {
                this.database = nsPart;
                this.collection = null;
            } else {
                this.database = nsPart.substring(0, idx);
                this.collection = nsPart.substring(idx + 1);
            }
        } else {
            this.database = null;
            this.collection = null;
        }
        this.parseOptions(optionsPart, builder);
    }

    private void parseOptions(String optionsPart, MongoClientOptions.Builder builder) {
        String readPreferenceType = null;
        DBObject firstTagSet = null;
        ArrayList<DBObject> remainingTagSets = new ArrayList<DBObject>();
        Boolean safe = null;
        String w = null;
        int wTimeout = 0;
        boolean fsync = false;
        boolean journal = false;
        Boolean slaveOk = null;
        for (String _part : optionsPart.split("&|;")) {
            int idx = _part.indexOf("=");
            if (idx < 0) continue;
            String key = _part.substring(0, idx).toLowerCase();
            String value = _part.substring(idx + 1);
            if (key.equals("maxpoolsize")) {
                builder.connectionsPerHost(Integer.parseInt(value));
                continue;
            }
            if (key.equals("waitqueuemultiple")) {
                builder.threadsAllowedToBlockForConnectionMultiplier(Integer.parseInt(value));
                continue;
            }
            if (key.equals("waitqueuetimeoutms")) {
                builder.maxWaitTime(Integer.parseInt(value));
                continue;
            }
            if (key.equals("connecttimeoutms")) {
                builder.connectTimeout(Integer.parseInt(value));
                continue;
            }
            if (key.equals("sockettimeoutms")) {
                builder.socketTimeout(Integer.parseInt(value));
                continue;
            }
            if (key.equals("autoconnectretry")) {
                builder.autoConnectRetry(this._parseBoolean(value));
                continue;
            }
            if (key.equals("slaveok")) {
                slaveOk = this._parseBoolean(value);
                continue;
            }
            if (key.equals("readpreference")) {
                readPreferenceType = value;
                continue;
            }
            if (key.equals("readpreferencetags")) {
                DBObject tagSet = this.getTagSet(value.trim());
                if (firstTagSet == null) {
                    firstTagSet = tagSet;
                    continue;
                }
                remainingTagSets.add(tagSet);
                continue;
            }
            if (key.equals("safe")) {
                safe = this._parseBoolean(value);
                continue;
            }
            if (key.equals("w")) {
                w = value;
                continue;
            }
            if (key.equals("wtimeout")) {
                wTimeout = Integer.parseInt(value);
                continue;
            }
            if (key.equals("fsync")) {
                fsync = this._parseBoolean(value);
                continue;
            }
            if (key.equals("j")) {
                journal = this._parseBoolean(value);
                continue;
            }
            LOGGER.warning("Unknown or Unsupported Option '" + key + "'");
        }
        this.buildWriteConcern(builder, safe, w, wTimeout, fsync, journal);
        this.buildReadPreference(builder, readPreferenceType, firstTagSet, remainingTagSets, slaveOk);
        this._options = builder.build();
    }

    private void buildReadPreference(MongoClientOptions.Builder builder, String readPreferenceType, DBObject firstTagSet, List<DBObject> remainingTagSets, Boolean slaveOk) {
        if (readPreferenceType != null) {
            if (firstTagSet == null) {
                builder.readPreference(ReadPreference.valueOf(readPreferenceType));
            } else {
                builder.readPreference(ReadPreference.valueOf(readPreferenceType, firstTagSet, remainingTagSets.toArray(new DBObject[remainingTagSets.size()])));
            }
        } else if (slaveOk != null && slaveOk.equals(Boolean.TRUE)) {
            builder.readPreference(ReadPreference.secondaryPreferred());
        }
    }

    private void buildWriteConcern(MongoClientOptions.Builder builder, Boolean safe, String w, int wTimeout, boolean fsync, boolean journal) {
        if (w != null || wTimeout != 0 || fsync || journal) {
            if (w == null) {
                builder.writeConcern(new WriteConcern(1, wTimeout, fsync, journal));
            } else {
                try {
                    builder.writeConcern(new WriteConcern(Integer.parseInt(w), wTimeout, fsync, journal));
                }
                catch (NumberFormatException e) {
                    builder.writeConcern(new WriteConcern(w, wTimeout, fsync, journal));
                }
            }
        } else if (safe != null) {
            if (safe.booleanValue()) {
                builder.writeConcern(WriteConcern.ACKNOWLEDGED);
            } else {
                builder.writeConcern(WriteConcern.UNACKNOWLEDGED);
            }
        }
    }

    private DBObject getTagSet(String tagSetString) {
        BasicDBObject tagSet = new BasicDBObject();
        if (tagSetString.length() > 0) {
            for (String tag : tagSetString.split(",")) {
                String[] tagKeyValuePair = tag.split(":");
                if (tagKeyValuePair.length != 2) {
                    throw new IllegalArgumentException("Bad read preference tags: " + tagSetString);
                }
                tagSet.put(tagKeyValuePair[0].trim(), (Object)tagKeyValuePair[1].trim());
            }
        }
        return tagSet;
    }

    boolean _parseBoolean(String _in) {
        String in = _in.trim();
        return in != null && in.length() > 0 && (in.equals("1") || in.toLowerCase().equals("true") || in.toLowerCase().equals("yes"));
    }

    public String getUsername() {
        return this.userName;
    }

    public char[] getPassword() {
        return this.password;
    }

    public List<String> getHosts() {
        return this._hosts;
    }

    public String getDatabase() {
        return this.database;
    }

    public String getCollection() {
        return this.collection;
    }

    public String getURI() {
        return this._uri;
    }

    public MongoClientOptions getOptions() {
        return this._options;
    }

    public String toString() {
        return this._uri;
    }
}

