/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.net.UnknownHostException;
import java.util.List;
import shaded.com.mongodb.DB;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.Mongo;
import shaded.com.mongodb.MongoClientOptions;
import shaded.com.mongodb.MongoClientURI;
import shaded.com.mongodb.MongoOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MongoURI {
    public static final String MONGODB_PREFIX = "mongodb://";
    private final MongoClientURI mongoClientURI;
    private final MongoOptions mongoOptions;

    public MongoURI(String uri) {
        this.mongoClientURI = new MongoClientURI(uri, new MongoClientOptions.Builder().legacyDefaults());
        this.mongoOptions = new MongoOptions(this.mongoClientURI.getOptions());
    }

    public MongoURI(MongoClientURI mongoClientURI) {
        this.mongoClientURI = mongoClientURI;
        this.mongoOptions = new MongoOptions(mongoClientURI.getOptions());
    }

    public String getUsername() {
        return this.mongoClientURI.getUsername();
    }

    public char[] getPassword() {
        return this.mongoClientURI.getPassword();
    }

    public List<String> getHosts() {
        return this.mongoClientURI.getHosts();
    }

    public String getDatabase() {
        return this.mongoClientURI.getDatabase();
    }

    public String getCollection() {
        return this.mongoClientURI.getCollection();
    }

    public MongoOptions getOptions() {
        return this.mongoOptions;
    }

    public Mongo connect() throws UnknownHostException {
        return new Mongo(this);
    }

    public DB connectDB() throws UnknownHostException {
        return this.connect().getDB(this.getDatabase());
    }

    public DB connectDB(Mongo mongo) {
        return mongo.getDB(this.getDatabase());
    }

    public DBCollection connectCollection(DB db) {
        return db.getCollection(this.getCollection());
    }

    public DBCollection connectCollection(Mongo mongo) {
        return this.connectDB(mongo).getCollection(this.getCollection());
    }

    public String toString() {
        return this.mongoClientURI.toString();
    }
}

