/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import shaded.com.mongodb.DBCollection;
import shaded.com.mongodb.DBEncoder;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DefaultDBEncoder;
import shaded.com.mongodb.Mongo;
import shaded.com.mongodb.MongoInternalException;
import shaded.com.mongodb.ReadPreference;
import shaded.com.mongodb.WriteConcern;
import shaded.org.bson.BSONObject;
import shaded.org.bson.BasicBSONEncoder;
import shaded.org.bson.io.PoolOutputBuffer;
import shaded.org.bson.types.ObjectId;

class OutMessage
extends BasicBSONEncoder {
    static AtomicInteger REQUEST_ID = new AtomicInteger(1);
    private final Mongo _mongo;
    private final DBCollection _collection;
    private PoolOutputBuffer _buffer;
    private final int _id;
    private final OpCode _opCode;
    private final int _queryOptions;
    private final DBObject _query;
    private final DBEncoder _encoder;
    private volatile int _numDocuments;

    public static OutMessage insert(DBCollection collection, DBEncoder encoder, WriteConcern concern) {
        OutMessage om = new OutMessage(collection, OpCode.OP_INSERT, encoder);
        om.writeInsertPrologue(concern);
        return om;
    }

    public static OutMessage update(DBCollection collection, DBEncoder encoder, boolean upsert, boolean multi, DBObject query, DBObject o) {
        OutMessage om = new OutMessage(collection, OpCode.OP_UPDATE, encoder, query);
        om.writeUpdate(upsert, multi, query, o);
        return om;
    }

    public static OutMessage remove(DBCollection collection, DBEncoder encoder, DBObject query) {
        OutMessage om = new OutMessage(collection, OpCode.OP_DELETE, encoder, query);
        om.writeRemove();
        return om;
    }

    static OutMessage query(DBCollection collection, int options, int numToSkip, int batchSize, DBObject query, DBObject fields) {
        return OutMessage.query(collection, options, numToSkip, batchSize, query, fields, ReadPreference.primary());
    }

    static OutMessage query(DBCollection collection, int options, int numToSkip, int batchSize, DBObject query, DBObject fields, ReadPreference readPref) {
        return OutMessage.query(collection, options, numToSkip, batchSize, query, fields, readPref, DefaultDBEncoder.FACTORY.create());
    }

    static OutMessage query(DBCollection collection, int options, int numToSkip, int batchSize, DBObject query, DBObject fields, ReadPreference readPref, DBEncoder enc) {
        OutMessage om = new OutMessage(collection, enc, query, options, readPref);
        om.writeQuery(fields, numToSkip, batchSize);
        return om;
    }

    static OutMessage getMore(DBCollection collection, long cursorId, int batchSize) {
        OutMessage om = new OutMessage(collection, OpCode.OP_GETMORE);
        om.writeGetMore(cursorId, batchSize);
        return om;
    }

    static OutMessage killCursors(Mongo mongo, int numCursors) {
        OutMessage om = new OutMessage(mongo, OpCode.OP_KILL_CURSORS);
        om.writeKillCursorsPrologue(numCursors);
        return om;
    }

    private OutMessage(Mongo m, OpCode opCode) {
        this(null, m, opCode, null);
    }

    private OutMessage(DBCollection collection, OpCode opCode) {
        this(collection, opCode, null);
    }

    private OutMessage(DBCollection collection, OpCode opCode, DBEncoder enc) {
        this(collection, collection.getDB().getMongo(), opCode, enc);
    }

    private OutMessage(DBCollection collection, Mongo m, OpCode opCode, DBEncoder enc) {
        this(collection, m, opCode, enc, null, -1, null);
    }

    private OutMessage(DBCollection collection, OpCode opCode, DBEncoder enc, DBObject query) {
        this(collection, collection.getDB().getMongo(), opCode, enc, query, 0, null);
    }

    private OutMessage(DBCollection collection, DBEncoder enc, DBObject query, int options, ReadPreference readPref) {
        this(collection, collection.getDB().getMongo(), OpCode.OP_QUERY, enc, query, options, readPref);
    }

    private OutMessage(DBCollection collection, Mongo m, OpCode opCode, DBEncoder enc, DBObject query, int options, ReadPreference readPref) {
        this._collection = collection;
        this._mongo = m;
        this._encoder = enc;
        this._buffer = this._mongo._bufferPool.get();
        this._buffer.reset();
        this.set(this._buffer);
        this._id = REQUEST_ID.getAndIncrement();
        this._opCode = opCode;
        this.writeMessagePrologue(opCode);
        if (query == null) {
            this._query = null;
            this._queryOptions = 0;
        } else {
            this._query = query;
            int allOptions = options;
            if (readPref != null && readPref.isSlaveOk()) {
                allOptions |= 4;
            }
            this._queryOptions = allOptions;
        }
    }

    private void writeInsertPrologue(WriteConcern concern) {
        int flags = 0;
        if (concern.getContinueOnErrorForInsert()) {
            flags |= 1;
        }
        this.writeInt(flags);
        this.writeCString(this._collection.getFullName());
    }

    private void writeUpdate(boolean upsert, boolean multi, DBObject query, DBObject o) {
        this.writeInt(0);
        this.writeCString(this._collection.getFullName());
        int flags = 0;
        if (upsert) {
            flags |= 1;
        }
        if (multi) {
            flags |= 2;
        }
        this.writeInt(flags);
        this.putObject(query);
        this.putObject(o);
    }

    private void writeRemove() {
        this.writeInt(0);
        this.writeCString(this._collection.getFullName());
        Set<String> keys = this._query.keySet();
        if (keys.size() == 1 && ((String)keys.iterator().next()).equals("_id") && this._query.get((String)keys.iterator().next()) instanceof ObjectId) {
            this.writeInt(1);
        } else {
            this.writeInt(0);
        }
        this.putObject(this._query);
    }

    private void writeGetMore(long cursorId, int batchSize) {
        this.writeInt(0);
        this.writeCString(this._collection.getFullName());
        this.writeInt(batchSize);
        this.writeLong(cursorId);
    }

    private void writeKillCursorsPrologue(int numCursors) {
        this.writeInt(0);
        this.writeInt(numCursors);
    }

    private void writeQuery(DBObject fields, int numToSkip, int batchSize) {
        this.writeInt(this._queryOptions);
        this.writeCString(this._collection.getFullName());
        this.writeInt(numToSkip);
        this.writeInt(batchSize);
        this.putObject(this._query);
        if (fields != null) {
            this.putObject(fields);
        }
    }

    private void writeMessagePrologue(OpCode opCode) {
        this.writeInt(0);
        this.writeInt(this._id);
        this.writeInt(0);
        this.writeInt(opCode.getValue());
    }

    void prepare() {
        if (this._buffer == null) {
            throw new IllegalStateException("Already closed");
        }
        this._buffer.writeInt(0, this._buffer.size());
    }

    void pipe(OutputStream out) throws IOException {
        if (this._buffer == null) {
            throw new IllegalStateException("Already closed");
        }
        this._buffer.pipe(out);
    }

    int size() {
        if (this._buffer == null) {
            throw new IllegalStateException("Already closed");
        }
        return this._buffer.size();
    }

    void doneWithMessage() {
        if (this._buffer == null) {
            throw new IllegalStateException("Only call this once per instance");
        }
        this._buffer.reset();
        this._mongo._bufferPool.done(this._buffer);
        this._buffer = null;
        this.done();
    }

    boolean hasOption(int option) {
        return (this._queryOptions & option) != 0;
    }

    int getId() {
        return this._id;
    }

    OpCode getOpCode() {
        return this._opCode;
    }

    DBObject getQuery() {
        return this._query;
    }

    String getNamespace() {
        return this._collection != null ? this._collection.getFullName() : null;
    }

    int getNumDocuments() {
        return this._numDocuments;
    }

    public int putObject(BSONObject o) {
        if (this._buffer == null) {
            throw new IllegalStateException("Already closed");
        }
        int objectSize = this._encoder.writeObject(this._buf, o);
        if (objectSize > Math.max(this._mongo.getConnector().getMaxBsonObjectSize(), 0x400000)) {
            throw new MongoInternalException("DBObject of size " + objectSize + " is over Max BSON size " + this._mongo.getMaxBsonObjectSize());
        }
        ++this._numDocuments;
        return objectSize;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OpCode {
        OP_UPDATE(2001),
        OP_INSERT(2002),
        OP_QUERY(2004),
        OP_GETMORE(2005),
        OP_DELETE(2006),
        OP_KILL_CURSORS(2007);

        private final int value;

        private OpCode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

