/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.util;

public class Base64Codec {
    private static int BYTES_PER_UNENCODED_BLOCK = 3;
    private static int BYTES_PER_ENCODED_BLOCK = 4;
    private static final int SixBitMask = 63;
    private static final byte PAD = 61;
    private static final byte[] EncodeTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public String encode(byte[] in) {
        int modulus = 0;
        int bitWorkArea = 0;
        int numEncodedBytes = in.length / BYTES_PER_UNENCODED_BLOCK * BYTES_PER_ENCODED_BLOCK + (in.length % BYTES_PER_UNENCODED_BLOCK == 0 ? 0 : 4);
        byte[] buffer = new byte[numEncodedBytes];
        int pos = 0;
        for (int i = 0; i < in.length; ++i) {
            modulus = (modulus + 1) % BYTES_PER_UNENCODED_BLOCK;
            int b = in[i];
            if (b < 0) {
                b += 256;
            }
            bitWorkArea = (bitWorkArea << 8) + b;
            if (0 != modulus) continue;
            buffer[pos++] = EncodeTable[bitWorkArea >> 18 & 0x3F];
            buffer[pos++] = EncodeTable[bitWorkArea >> 12 & 0x3F];
            buffer[pos++] = EncodeTable[bitWorkArea >> 6 & 0x3F];
            buffer[pos++] = EncodeTable[bitWorkArea & 0x3F];
        }
        switch (modulus) {
            case 1: {
                buffer[pos++] = EncodeTable[bitWorkArea >> 2 & 0x3F];
                buffer[pos++] = EncodeTable[bitWorkArea << 4 & 0x3F];
                buffer[pos++] = 61;
                buffer[pos++] = 61;
                break;
            }
            case 2: {
                buffer[pos++] = EncodeTable[bitWorkArea >> 10 & 0x3F];
                buffer[pos++] = EncodeTable[bitWorkArea >> 4 & 0x3F];
                buffer[pos++] = EncodeTable[bitWorkArea << 2 & 0x3F];
                buffer[pos++] = 61;
            }
        }
        return new String(buffer);
    }
}

