/*
 * Decompiled with CFR 0.152.
 */
package shaded.com.mongodb.util;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;
import shaded.com.mongodb.BasicDBList;
import shaded.com.mongodb.BasicDBObject;
import shaded.com.mongodb.DBObject;
import shaded.com.mongodb.DBRef;
import shaded.org.bson.BSON;
import shaded.org.bson.BSONObject;
import shaded.org.bson.BasicBSONCallback;
import shaded.org.bson.types.BSONTimestamp;
import shaded.org.bson.types.Code;
import shaded.org.bson.types.CodeWScope;
import shaded.org.bson.types.MaxKey;
import shaded.org.bson.types.MinKey;
import shaded.org.bson.types.ObjectId;

public class JSONCallback
extends BasicBSONCallback {
    private boolean _lastArray = false;
    public static final String _msDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String _secDateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    public BSONObject create() {
        return new BasicDBObject();
    }

    protected BSONObject createList() {
        return new BasicDBList();
    }

    public void objectStart(boolean array, String name) {
        this._lastArray = array;
        super.objectStart(array, name);
    }

    public Object objectDone() {
        String name = this.curName();
        Object o = super.objectDone();
        BSONObject b = (BSONObject)o;
        if (!this._lastArray) {
            if (b.containsField("$oid")) {
                o = new ObjectId((String)b.get("$oid"));
                if (!this.isStackEmpty()) {
                    this.gotObjectId(name, (ObjectId)o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$date")) {
                if (b.get("$date") instanceof Number) {
                    o = new Date(((Number)b.get("$date")).longValue());
                } else {
                    SimpleDateFormat format = new SimpleDateFormat(_msDateFormat);
                    format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                    o = format.parse(b.get("$date").toString(), new ParsePosition(0));
                    if (o == null) {
                        format = new SimpleDateFormat(_secDateFormat);
                        format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                        o = format.parse(b.get("$date").toString(), new ParsePosition(0));
                    }
                }
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$regex")) {
                o = Pattern.compile((String)b.get("$regex"), BSON.regexFlags((String)b.get("$options")));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$ts")) {
                Long ts = ((Number)b.get("$ts")).longValue();
                Long inc = ((Number)b.get("$inc")).longValue();
                o = new BSONTimestamp(ts.intValue(), inc.intValue());
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$code")) {
                o = b.containsField("$scope") ? new CodeWScope((String)b.get("$code"), (DBObject)b.get("$scope")) : new Code((String)b.get("$code"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$ref")) {
                o = new DBRef(null, (String)b.get("$ref"), b.get("$id"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$minKey")) {
                o = new MinKey();
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$maxKey")) {
                o = new MaxKey();
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            } else if (b.containsField("$uuid")) {
                o = UUID.fromString((String)b.get("$uuid"));
                if (!this.isStackEmpty()) {
                    this.cur().put(name, o);
                } else {
                    this.setRoot(o);
                }
            }
        }
        return o;
    }
}

