/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.bson;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import shaded.org.bson.BSONCallback;
import shaded.org.bson.BSONDecoder;
import shaded.org.bson.BSONException;
import shaded.org.bson.BSONObject;
import shaded.org.bson.LazyBSONCallback;
import shaded.org.bson.io.Bits;

public class LazyBSONDecoder
implements BSONDecoder {
    static final Logger LOG = Logger.getLogger(LazyBSONDecoder.class.getName());
    private static int BYTES_IN_INTEGER = 4;

    public BSONObject readObject(byte[] b) {
        try {
            return this.readObject(new ByteArrayInputStream(b));
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public BSONObject readObject(InputStream in) throws IOException {
        LazyBSONCallback c = new LazyBSONCallback();
        this.decode(in, (BSONCallback)c);
        return (BSONObject)c.get();
    }

    public int decode(byte[] b, BSONCallback callback) {
        try {
            return this.decode(new ByteArrayInputStream(b), callback);
        }
        catch (IOException ioe) {
            throw new BSONException("should be impossible", ioe);
        }
    }

    public int decode(InputStream in, BSONCallback callback) throws IOException {
        byte[] objSizeBuffer = new byte[BYTES_IN_INTEGER];
        Bits.readFully(in, objSizeBuffer, 0, BYTES_IN_INTEGER);
        int objSize = Bits.readInt(objSizeBuffer);
        byte[] data = new byte[objSize];
        System.arraycopy(objSizeBuffer, 0, data, 0, BYTES_IN_INTEGER);
        Bits.readFully(in, data, BYTES_IN_INTEGER, objSize - BYTES_IN_INTEGER);
        callback.gotBinary(null, (byte)0, data);
        return objSize;
    }
}

