/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql;

import java.sql.SQLException;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.IOUtilities;
import net.sourceforge.squirrel_sql.fw.util.IOUtilitiesImpl;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import org.apache.log4j.Level;
import org.easymock.EasyMock;
import utils.EasyMockHelper;

public abstract class BaseSQuirreLJUnit4TestCase {
    public static final String TEST_QUALIFIED_NAME = "testQualifiedName";
    public static final String TEST_SIMPLE_NAME = "testSimpleName";
    public static final String TEST_CATALOG_NAME = "testCatalogName";
    public static final String TEST_SCHEMA_NAME = "testSchemaName";
    public static final String TEST_DATABASE_PRODUCT_NAME = "testDatabaseProductName";
    public static final String TEST_DATABASE_PRODUCT_VERSION = "testDatabaseProductVersion";
    protected EasyMockHelper mockHelper = new EasyMockHelper();
    protected IOUtilities ioutil = new IOUtilitiesImpl();

    public BaseSQuirreLJUnit4TestCase() {
        StringManager.setTestMode((boolean)true);
    }

    protected static void disableLogging(Class c) {
        ILogger s_log = LoggerController.createLogger((Class)c);
        s_log.setLevel(Level.OFF);
    }

    protected static void debugLogging(Class c) {
        ILogger s_log = LoggerController.createLogger((Class)c);
        s_log.setLevel(Level.DEBUG);
    }

    protected void setupDboExpectations(IDatabaseObjectInfo info) {
        EasyMock.expect((Object)info.getCatalogName()).andStubReturn((Object)TEST_CATALOG_NAME);
        EasyMock.expect((Object)info.getSchemaName()).andStubReturn((Object)TEST_SCHEMA_NAME);
        EasyMock.expect((Object)info.getSimpleName()).andStubReturn((Object)TEST_SIMPLE_NAME);
        EasyMock.expect((Object)info.getQualifiedName()).andStubReturn((Object)TEST_QUALIFIED_NAME);
    }

    protected void setupSqlDatabaseMetaDataExpectations(ISQLDatabaseMetaData md) throws SQLException {
        EasyMock.expect((Object)md.getDatabaseProductName()).andStubReturn((Object)TEST_DATABASE_PRODUCT_NAME);
        EasyMock.expect((Object)md.getDatabaseProductVersion()).andStubReturn((Object)TEST_DATABASE_PRODUCT_VERSION);
        EasyMock.expect((Object)md.supportsSchemasInDataManipulation()).andStubReturn((Object)true);
        EasyMock.expect((Object)md.supportsCatalogsInDataManipulation()).andStubReturn((Object)true);
        EasyMock.expect((Object)md.supportsSchemasInTableDefinitions()).andStubReturn((Object)true);
        EasyMock.expect((Object)md.getCatalogSeparator()).andStubReturn((Object)".");
        EasyMock.expect((Object)md.getIdentifierQuoteString()).andStubReturn((Object)"\"");
    }
}

