/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.codereformat;

import net.sourceforge.squirrel_sql.BaseSQuirreLTestCase;
import net.sourceforge.squirrel_sql.fw.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.fw.codereformat.CommentSpec;

public class CodeReformatorTest
extends BaseSQuirreLTestCase {
    CodeReformator c = null;
    private static CommentSpec[] COMMENT_SPECS = new CommentSpec[]{new CommentSpec("/*", "*/"), new CommentSpec("--", "\n")};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.c = new CodeReformator(";", COMMENT_SPECS);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.c = null;
    }

    public void testReformat() {
        CodeReformator c = new CodeReformator(";", COMMENT_SPECS);
        c.reformat("insert into MY_TEST_TABLE ( SELECT_COL_1 , SELECT_COL_2 ) values ( ( select 1 from sysibm.sysdummy1 ) , ( select 1 from sysibm.sysdummy1 ) )");
        c.reformat("create table student (     sno     integer,     sname   varchar(10),     age     integer ); ");
        c.reformat("create table courses (     cno     varchar(5),     title   varchar(10),     credits integer ); ");
        c.reformat("create table professor (     lname   varchar(10),     dept    varchar(10),     salary  integer,     age     integer ); ");
        c.reformat("create table take (     sno     integer,     cno varchar(15) ); ");
        c.reformat("create table teach (     lname   varchar(10),     cno     varchar(5) ); ");
        c.reformat("select * from student where sno not in (select sno                   from take                   where cno = 'CS112'); ");
        c.reformat("CREATE PROCEDURE TRANSFER (:FROM CHAR(7),:TO CHAR(7),:AMOUNT DECIMAL(7,2)) BEGIN /* remove the amount from FROM account */ UPDATE ACCOUNTS SET BALANCE = BALANCE - :AMOUNT WHERE ACCOUNT_ID = :FROM ; /* add the amount to TO account */ UPDATE ACCOUNTS SET BALANCE = BALANCE + AMOUNT WHERE ACCOUNT_ID = :TO ; END; ");
        c.reformat("CREATE PROCEDURE TRANSFER ( :FROM    CHAR(7),                             :TO      CHAR(7),                             :AMOUNT  DECIMAL(7,2) )     BEGIN         /* remove the amount from FROM account */         UPDATE ACCOUNTS         SET BALANCE = BALANCE - :AMOUNT         WHERE ACCOUNT_ID = :FROM ;          /* add the amount to TO account */         UPDATE ACCOUNTS         SET BALANCE = BALANCE + AMOUNT         WHERE ACCOUNT_ID = :TO ;     END; ");
        c.reformat("select 'X' from dual;");
        c.reformat("select 'X' from dual;");
        c.reformat("select 1/100 from dual;");
        c.reformat(" create procedure fooproc (Person_name IN varchar2) \nAS \nBEGIN \n    insert into testdate \n            (mydate) \n    values \n            (sysdate); \nEND; \n \n/ \n\n;");
        c.reformat("create or replace procedure fooproc (Person_name IN varchar2) \nAS \nBEGIN \n    insert into testdate \n            (mydate) \n    values \n            (sysdate); \nEND; \n \n/ \n\n;");
        c.reformat("declare \nv_foo number(10); \nv_bar number(10); \nbegin \n   for usr in \n       (select * from foo_bar where user like 'TST%') \n       loop \n       begin \n            update STUDENT set AGE = 13 where SNO = 100000; \n       end; \n   end loop; \nend; \n/ \n\n");
        c.reformat("update test set /*PARAM1*/ thing /*C*/ = 'default value' /*/PARAM1*/;");
        c.reformat("select s.sno, s.sname, s.age from student s, take t where s.SNO = t.SNO (+) group by s.sno, s.SNAME, s.AGE having max(case when t.cno = 'CS112'                 then 1 else 0 end) = 0; ");
        c.reformat("create table FOOB_CAB  (\n   CABID                INTEGER                          not null,\n   Name                 VARCHAR2(100)                    not null,\n   Description          CLOB,\n   constraint PK_FOOB_CAB primary key (ALCID)\n)\n/\n\ncreate table FOOB_Add12EmakeTypo  (\n   Add12EmakeTypo       VARCHAR2(35)                     not null,\n   Description          VARCHAR2(255),\n   constraint PK_FOOB_Add12EmakeTypo primary key (Add12EmakeTypo)\n)\n/\n");
        c.reformat("create or replace function airport_city(iata_code in char) return varchar2 is     city_name varchar2(50); begin     select city     into city_name     from iata_airport_codes     where code = iata_code     return (city_name); end;\n/\n");
    }

    public void testReformatSemiColonStatementSeparator() {
        this.c = new CodeReformator(";", COMMENT_SPECS);
        String pipeSql = "CREATE TABLE BIGINT_VIEW ( BIGINT_COLUMN bigint ); ";
        this.c.reformat(pipeSql);
    }

    public void testReformatPipeStatementSeparator() {
        this.c = new CodeReformator("|", COMMENT_SPECS);
        String pipeSql = "CREATE TABLE BIGINT_VIEW ( BIGINT_COLUMN bigint )| ";
        this.c.reformat(pipeSql);
        String pipeSql2 = "CREATE TABLE BIGINT_TYPE_TABLE \n( \n   ID int PRIMARY KEY NOT NULL, \n   NAME varchar(30) NOT NULL, \n   BIGINT_COLUMN bigint, \n   DESCRIPTION varchar(100), \n   CREATE_DATE date NOT NULL, \n   LAST_MODIFIED date NOT NULL \n)| \n \nCREATE UNIQUE INDEX PK_BIGINT ON BIGINT_TYPE_TABLE(ID)| \n \nCREATE UNIQUE INDEX BIGINT_NAME_IDX ON BIGINT_TYPE_TABLE(NAME)| \n";
        this.c.reformat(pipeSql2);
    }
}

